/*!
 * @package   yii2-grid
 * @author    Kartik Visweswaran <kartikv2@gmail.com>
 * @copyright Copyright &copy; Kartik Visweswaran, Krajee.com, 2014 - 2016
 * @version   3.1.0
 *
 * Grid Export Validation Module for Yii's Gridview. Supports export of
 * grid data as CSV, HTML, or Excel.
 *
 * Author: Kartik Visweswaran
 * Copyright: 2015, Kartik Visweswaran, Krajee.com
 * For more JQuery plugins visit http://plugins.krajee.com
 * For more Yii related demos visit http://demos.krajee.com
 */!function(e){"use strict";var t,o,n,r,i,a,l="urn:schemas-microsoft-com:office:";t=function(e,t,o){return e.split(t).join(o)},o=function(t,o){return null===t||void 0===t||0===t.length||o&&""===e.trim(t)},n=function(e,t,o,n){var r=screen.width/2-o/2,i=60,a=window.open("",t,"",!0);return a.close(),window.open(e,t,"toolbar=no, location=no, directories=no, status=yes, menubar=no, scrollbars=no, resizable=no, copyhistory=no, width="+o+", height="+n+", top="+i+", left="+r)},r=function(e){return e.toLowerCase().replace(/[^\w ]+/g,"").replace(/ +/g,"-")},i={html:'<!DOCTYPE html><meta http-equiv="Content-Type" content="text/html;charset={encoding}"/><meta http-equiv="X-UA-Compatible" content="IE=edge;chrome=1"/>{css}<style>.kv-wrap{padding:20px;}.kv-align-center{text-align:center;}.kv-align-left{text-align:left;}.kv-align-right{text-align:right;}.kv-align-top{vertical-align:top!important;}.kv-align-bottom{vertical-align:bottom!important;}.kv-align-middle{vertical-align:middle!important;}.kv-page-summary{border-top:4px double #ddd;font-weight: bold;}.kv-table-footer{border-top:4px double #ddd;font-weight: bold;}.kv-table-caption{font-size:1.5em;padding:8px;border:1px solid #ddd;border-bottom:none;}</style><body class="kv-wrap">{data}</body>',pdf:"{before}\n{data}\n{after}",excel:'<html xmlns:o="'+l+'office" xmlns:x="'+l+'excel" xmlns="http://www.w3.org/TR/REC-html40"><head><meta http-equiv="Content-Type" content="text/html;charset={encoding}"/>{css}<!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{worksheet}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--></head><body>{data}</body></html>',popup:'<html style="display:table;width:100%;height:100%;"><title>Grid Export - &copy; Krajee</title><body style="display:table-cell;font-family:Helvetica,Arial,sans-serif;color:#888;font-weight:bold;line-height:1.4em;text-align:center;vertical-align:middle;width:100%;height:100%;padding:0 10px;">{msg}</body></html>'},a=function(t,o){var n=this,r=o.gridOpts,i=o.genOpts;n.$element=e(t),n.$grid=e("#"+r.gridId),n.messages=r.messages,n.target=r.target,n.exportConversions=r.exportConversions,n.showConfirmAlert=r.showConfirmAlert,n.filename=i.filename,n.showHeader=i.showHeader,n.showFooter=i.showFooter,n.showPageSummary=i.showPageSummary,n.$table=n.$grid.find(".kv-grid-table:first"),n.$form=n.$grid.find("form.kv-export-form"),n.encoding=n.$form.find('[name="export_encoding"]').val(),n.columns=n.showHeader?"td,th":"td",n.alertMsg=o.alertMsg,n.config=o.config,n.popup="",n.listen()},a.prototype={constructor:a,getArray:function(t){var n=this,i=n.clean(t),a=[],l={};return void 0!==n.config.colHeads&&n.config.colHeads.length>0?a=n.config.colHeads:i.find("thead tr th").each(function(t){var i=e(this).text().trim(),l=r(i);a[t]=!n.config.slugColHeads||o(l)?"col_"+t:l}),i.find('tbody tr:has("td")').each(function(t){l[t]={},e(this).children("td").each(function(o){var n=a[o];l[t][n]=e(this).text().trim()})}),l},notify:function(e){var t=this;if(!t.showConfirmAlert)return e.preventDefault(),!0;var n=t.messages,r=o(t.alertMsg)?"":t.alertMsg,i=o(n.allowPopups)?"":n.allowPopups,a=o(n.confirmDownload)?"":n.confirmDownload,l="";return l=r.length&&i.length?r+"\n\n"+i:!r.length&&i.length?i:r.length&&!i.length?r:"",a.length&&(l=l+"\n\n"+a),e.preventDefault(),o(l)?!0:t.kvConfirm(l)},kvConfirm:function(e){try{return window.confirm(e)}catch(t){return!0}},setPopupAlert:function(e){var t=this;if(void 0!==t.popup.document)if(arguments.length&&arguments[1]){var o=t.popup.document.getElementsByTagName("body");setTimeout(function(){o[0].innerHTML=e},4e3)}else{var n=i.popup.replace("{msg}",e);t.popup.document.write(n)}},listenClick:function(e){var t=this,n=arguments.length>1?arguments[1]:"";t.$element.on("click",function(r){t.notify(r)&&(o(n)?t[e]():t[e](n),r.preventDefault())})},listen:function(){var e=this;"_popup"===e.target&&e.$form.on("submit",function(){setTimeout(function(){e.setPopupAlert(e.messages.downloadComplete,!0)},1e3)}),e.$element.hasClass("export-csv")&&e.listenClick("exportTEXT","csv"),e.$element.hasClass("export-txt")&&e.listenClick("exportTEXT","txt"),e.$element.hasClass("export-html")&&e.listenClick("exportHTML"),e.$element.hasClass("export-xls")&&e.listenClick("exportEXCEL"),e.$element.hasClass("export-json")&&e.listenClick("exportJSON"),e.$element.hasClass("export-pdf")&&e.listenClick("exportPDF")},clean:function(t){var o=this,n=o.$table.clone();n.find("tr.filters").remove(),n.find("th").removeAttr("rowspan"),n.find("th").find("a").each(function(){e(this).contents().unwrap()}),n.find("input").remove(),o.showHeader||n.find("thead").remove(),o.showPageSummary||n.find("tfoot.kv-page-summary").remove(),o.showFooter||n.find("tfoot.kv-table-footer").remove(),o.showCaption||n.find("kv-table-caption").remove(),n.find(".skip-export").remove(),n.find(".skip-export-"+t).remove();var r=n.html();return r=o.preProcess(r),n.html(r),n},preProcess:function(e){var o,n=this,r=n.exportConversions,i=r.length,a=e;if(i>0)for(var l=0;i>l;l++)o=r[l],a=t(a,o.from,o.to);return a},download:function(e,t){var r=this,i=r.$element.data("format"),a=o(r.config)?{}:r.config;r.$form.find('[name="export_filetype"]').val(e),r.$form.find('[name="export_filename"]').val(r.filename),r.$form.find('[name="export_content"]').val(t),r.$form.find('[name="export_mime"]').val(i),r.$form.find('[name="export_config"]').val("pdf"===e?JSON.stringify(a):""),"_popup"===r.target&&(r.popup=n("","kvDownloadDialog",350,120),r.popup.focus(),r.setPopupAlert(r.messages.downloadProgress)),r.$form.submit()},exportHTML:function(){var t=this,o=t.clean("html"),n=t.config,r=t.config.cssFile&&n.cssFile.length?'<link href="'+t.config.cssFile+'" rel="stylesheet">':"",a=i.html.replace("{encoding}",t.encoding).replace("{css}",r).replace("{data}",e("<div />").html(o).html());t.download("html",a)},exportPDF:function(){var t=this,n=t.clean("pdf"),r=o(t.config.contentBefore)?"":t.config.contentBefore,a=o(t.config.contentAfter)?"":t.config.contentAfter,l=t.config.css,s=i.pdf.replace("{css}",l).replace("{before}",r).replace("{after}",a).replace("{data}",e("<div />").html(n).html());t.download("pdf",s)},exportTEXT:function(t){var o=this,n=o.clean(t),r=n.find("tr:has("+o.columns+")"),i=String.fromCharCode(11),a=String.fromCharCode(0),l='"'+o.config.colDelimiter+'"',s='"'+o.config.rowDelimiter+'"',c='"'+r.map(function(t,n){var r=e(n),a=r.find(o.columns);return a.map(function(t,o){var n=e(o),r=n.text().trim();return r.replace(/"/g,'""')}).get().join(i)}).get().join(a).split(a).join(s).split(i).join(l)+'"';o.download(t,c)},exportJSON:function(){var e=this,t=e.getArray("json");t=JSON.stringify(t,e.config.jsonReplacer,e.config.indentSpace),e.download("json",t)},exportEXCEL:function(){var t,o,n=this,r=n.clean("xls"),a=n.config,l=a.cssFile&&n.config.cssFile.length?'<link href="'+n.config.cssFile+'" rel="stylesheet">':"";r.find("td[data-raw-value]").each(function(){o=e(this),(o.css("mso-number-format")||0===o.css("mso-number-format")||"0"===o.css("mso-number-format"))&&o.html(o.attr("data-raw-value")).removeAttr("data-raw-value")}),t=i.excel.replace("{encoding}",n.encoding).replace("{css}",l).replace("{worksheet}",n.config.worksheet).replace("{data}",e("<div />").html(r).html()).replace(/"/g,"'"),n.download("xls",t)}},e.fn.gridexport=function(t){var o=Array.apply(null,arguments);return o.shift(),this.each(function(){var n=e(this),r=n.data("gridexport"),i="object"==typeof t&&t;r||n.data("gridexport",r=new a(this,e.extend({},e.fn.gridexport.defaults,i,e(this).data()))),"string"==typeof t&&r[t].apply(r,o)})},e.fn.gridexport.defaults={},e.fn.gridexport.Constructor=a}(window.jQuery);