
<?php

use yii\helpers\Html;
use yii\widgets\ListView;	
use common\modules\nam\models\norm\Argument;
use yii\data\ActiveDataProvider;
use common\modules\nam\models\content\Content;
use common\modules\nam\models\norm\ArgumentRate;
use yii\bootstrap\Tabs;
use kartik\rating\StarRating;
use yii\helpers\Url;


use common\modules\nam\views\norm\stars;


/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */


$this->title = Yii::t('norm', 'Norms');
// $this->params['breadcrumbs'][] = $this->title;

?>



<link href="http://maxcdn.bootstrapcdn.com/font-awesome/4.1.0/css/font-awesome.min.css" rel="stylesheet">
<link href="http://netdna.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.css" rel="stylesheet">
<link href="css/star-rating.css" media="all" rel="stylesheet" type="text/css" />




<br><br>
<?= Html::a(Yii::t('button', 'Create norm'), ['norm/createnorm'], ['class' => 'btn btn-primary']);?>
<br><br>

<?= Html::beginForm(
        Url::toRoute(""),//action
        "get",//method
        ['class' => 'form-inline']//options
    );
?>

<div class="form-group">
    <input type="radio" name="order" value="relevant"> Most relevant
    <input type="radio" name="order" value="newest"> Newest
    <input type="radio" name="order" value="oldest"> Oldest 
</div>

<?= Html::submitInput("Sort Arguments", ["class" => "btn btn-primary btn-xs"]) ?>

<?= Html::endForm() ?>
</br>

<?php 


echo Tabs::widget([
    'items' => [
        [
            'label' => 'Under Discussion', 
            'content' => ListView::widget([
        'dataProvider' => $dataProvider,
        'itemOptions' => ['class' => 'item'],
        'itemView' => function ($model, $key, $index, $widget) {
			if($model->active==0){
				return $this->render('view',['model' => $model, 'section' => 1, 'status' => 1]);
			}
        },
        'emptyText' => 'There are currently no norms under discussion.',

        'layout' => '{items}{pager}']),
		'active' => true
        ],
        [
            'label' => 'Active Norms',
            'content' => 
				ListView::widget([
					'dataProvider' => $dataProvider,
					'itemOptions' => ['class' => 'item'],
					'itemView' => function ($model, $key, $index, $widget) {
						if($model->active==1){
							return $this->render('view',['model' => $model, 'section' => 1, 'status' => 1]);
						}
					},
					'emptyText' => 'There are currently no active norms.',

					'layout' => '{items}{pager}']),
        ],
        [
            'label' => 'Inactive Norms',
            'content' => ListView::widget([
        'dataProvider' => $dataProvider,
        'itemOptions' => ['class' => 'item'],
        'itemView' => function ($model, $key, $index, $widget) {
			if($model->active==2){
				return $this->render('view',['model' => $model, 'section' => 1, 'status' => 1]);
			}
        },
        'emptyText' => 'There are currently no inactive norms.',

        'layout' => '{items}{pager}']),

        ],
    ],
]);
?>


<?php
/**
 * Function to show the arguments of the norm
 * @param unknown $type Type of the argument
 * @param unknown $model Norm model
 *
function showArguments($type, $model){
	$sql = 'select * from argument where type = '.$type.' && norm = '.$model['id'];
	$query = Argument::findBySql($sql);
	$dataProvider = new ActiveDataProvider(['query' => $query]);
	$models = $dataProvider->models;
	$rate = 0;
	foreach($models as $modelArgument){
		?><li>
			<?php
			$description = $modelArgument['description'];
			if(is_numeric($description)){
				$content = Content::findOne($description);
				echo 'Content such as '.Html::a(Html::encode($content['title']), ['/nam/content/view', 'id' => $modelArgument['description']], ['class' => '']) .' should not be published to upload this content ';
				echo generateStarIcons($modelArgument['rate']).'  ('.$modelArgument['numrate']?><i class="fa fa-user"></i><?php echo ')' ?>

			<?php }else{
				echo Html::encode($description)." ";
				echo generateStarIcons($modelArgument['rate']).'  ('.$modelArgument['numrate']?><i class="fa fa-user"></i><?php echo ')' ?>
			<?php }
			?>
	       <?php $content = '<form name="form" action="" method="get"> <input class="rating" data-max="5" data-min="1" id="input" type="number"/> </form>' ;?>
           <?php
	           if(ArgumentRate::isRated($modelArgument['id']) && (!$model->active)){
	           ?>	<span>Rate argument:<?php 
	           	echo Html::a(Yii::t('button', '1'), ['norm/rate', 'id_argument' => $modelArgument['id'], 'rating' =>1, 'norm' => $model['id'], 'section' => $model->section, 'category' => $model->complain_category], ['class' => 'glyphicon glyphicon-star']);
	           	echo Html::a(Yii::t('button', '2'), ['norm/rate', 'id_argument' => $modelArgument['id'], 'rating' =>2, 'norm' => $model['id'], 'section' => $model->section, 'category' => $model->complain_category], ['class' => 'glyphicon glyphicon-star']);
	           	echo Html::a(Yii::t('button', '3'), ['norm/rate', 'id_argument' => $modelArgument['id'], 'rating' =>3, 'norm' => $model['id'], 'section' => $model->section, 'category' => $model->complain_category], ['class' => 'glyphicon glyphicon-star']);
	           	echo Html::a(Yii::t('button', '4'), ['norm/rate', 'id_argument' => $modelArgument['id'], 'rating' =>4, 'norm' => $model['id'], 'section' => $model->section, 'category' => $model->complain_category], ['class' => 'glyphicon glyphicon-star']);
	           	echo Html::a(Yii::t('button', '5'), ['norm/rate', 'id_argument' => $modelArgument['id'], 'rating' =>5, 'norm' => $model['id'], 'section' => $model->section, 'category' => $model->complain_category], ['class' => 'glyphicon glyphicon-star']);
	           	 
	           	?> <?php
	           }
	           ?>
	   	</li>
<?php }
}
*/

function showNumArguments($type, $model, $num){ 
	$sql = 'select * from argument where type = '.$type.' && norm = '.$model['id'];
	$query = Argument::findBySql($sql);
	$dataProvider = new ActiveDataProvider(['query' => $query]);
	$models = $dataProvider->models;
	$rate = 0;
	$normalizedRate = 0.0;
	$normalizedNumRate = 0;
	$relevance=0.0;
	$i=0;
	foreach($models as $modelArgument){		
			$conn = new mysqli('localhost', 'root', '', 'yii2advanced');
			$sql = 'select * from argument where type = '.$type.' && norm = '.$model['id'];
			$result = $conn->query($sql);
			while($row = $result->fetch_assoc()) {
				$i=$i+$row['numrate'];
			
			}
			$normalizedRate=$modelArgument['rate']/5.0;
				
			
			if ($i>0) { $normalizedNumRate = $modelArgument['numrate']/$i;}
			$i=0;
			
			$relevance= 0.6*$normalizedRate+0.4*$normalizedNumRate;
			
			$normalizedNumRate=0.0;

			$sql = 'update argument set relevance='.$relevance.' where type = '.$type.' && id =' .$modelArgument['id'];
			$result = $conn->query($sql);
			
		?>
	       
<?php }
	if ((isset($_REQUEST['order'])) && ($_REQUEST['order']=='newest') ){
		$sql = 'select * from argument where type = '.$type.' && norm = '.$model['id'].' ORDER BY id DESC LIMIT ' .$num;
	} else if ((isset($_REQUEST['order'])) && ($_REQUEST['order']=='oldest') ){
		$sql = 'select * from argument where type = '.$type.' && norm = '.$model['id'].' ORDER BY id ASC LIMIT ' .$num;
	} else {
		$sql = 'select * from argument where type = '.$type.' && norm = '.$model['id'].' ORDER BY relevance DESC LIMIT ' .$num;
	}
	$query = Argument::findBySql($sql);
	$dataProvider = new ActiveDataProvider(['query' => $query]);
	$models = $dataProvider->models;

	foreach($models as $modelArgument){
		?><li>
			<?php
			$description = $modelArgument['description'];
			if(is_numeric($description)){
				$content = Content::findOne($description);
				echo 'Content such as '.Html::a(Html::encode($content['title']), ['/nam/content/view', 'id' => $modelArgument['description']], ['class' => '']) .' should not be published to upload this content ';
				echo generateStarIcons($modelArgument['rate']).'  ('.$modelArgument['numrate']?><i class="fa fa-user"></i><?php echo ')' ?>
			<?php }else{
					echo Html::encode($description)." ";?>
					<?php echo generateStarIcons($modelArgument['rate']).'  ('.$modelArgument['numrate']?><i class="fa fa-user"></i><?php echo ')';?> 
					
					<?php 				
					/*echo StarRating::widget([
						'name' => 'rating_35',
						'value' => $modelArgument['rate'],
						'pluginOptions' => ['showClear'=>false, 
						'showCaption'=>false,
						'step'=>1.0,
						'size'=>''],
						'pluginEvents' => ['rating.change'=>'function(event, value) {document.getElementById("stars").innerHTML = value;}']
					]);
					
					//echo stars->innerHTML;
					if ($starTag == 2) {
						echo "Si!";
					}*/
					?>
					
			<?php }
			?>

	       <?php $content = '<form name="form" action="" method="get"> <input class="rating" data-max="5" data-min="1" id="input" type="number"/> </form>' ;?>
           <?php
	           if(ArgumentRate::isRated($modelArgument['id']) && (!$model->active)){
	           ?>	<span>Rate argument:<?php 			
	           	echo Html::a(Yii::t('button', '1'), ['norm/rate', 'id_argument' => $modelArgument['id'], 'rating' =>1, 'norm' => $model['id'], 'section' => $model->section, 'category' => $model->complain_category], ['class' => 'glyphicon glyphicon-star']);
	           	echo Html::a(Yii::t('button', '2'), ['norm/rate', 'id_argument' => $modelArgument['id'], 'rating' =>2, 'norm' => $model['id'], 'section' => $model->section, 'category' => $model->complain_category], ['class' => 'glyphicon glyphicon-star']);
	           	echo Html::a(Yii::t('button', '3'), ['norm/rate', 'id_argument' => $modelArgument['id'], 'rating' =>3, 'norm' => $model['id'], 'section' => $model->section, 'category' => $model->complain_category], ['class' => 'glyphicon glyphicon-star']);
	           	echo Html::a(Yii::t('button', '4'), ['norm/rate', 'id_argument' => $modelArgument['id'], 'rating' =>4, 'norm' => $model['id'], 'section' => $model->section, 'category' => $model->complain_category], ['class' => 'glyphicon glyphicon-star']);
	           	echo Html::a(Yii::t('button', '5'), ['norm/rate', 'id_argument' => $modelArgument['id'], 'rating' =>5, 'norm' => $model['id'], 'section' => $model->section, 'category' => $model->complain_category], ['class' => 'glyphicon glyphicon-star']);

				?>
				<?php
	           }
	           ?>
	   	</li>
		
		<?php }
}
?>


<?php
function generateStarIcons($number){
	//Full star
	$num = floor($number);
	$rest = $number-$num;
	echo '<i title="'.$number.'">';
	for($i=0; $i<$num; $i++){
		echo '<i class="fa fa-star yellow"></i>';
	}

	//Half star
	if($rest >= 0.5){
		echo '<i class="fa fa-star-half-empty yellow"></i>';
		$i++;
	}

	//Empty star
	for($j=$i; $j<5; $j++){
		echo '<i class="fa fa-star-o yellow"></i>';
	}
	echo '</i>';
}
?>


<?php
function generateStarIcons2(){
	echo Html::a(Yii::t('button', '1'), ['norm/rate', 'id_argument' => $modelArgument['id'], 'rating' =>1, 'norm' => $model['id'], 'section' => $model->section, 'category' => $model->complain_category], ['class' => 'glyphicon glyphicon-star']);
	echo Html::a(Yii::t('button', '2'), ['norm/rate', 'id_argument' => $modelArgument['id'], 'rating' =>2, 'norm' => $model['id'], 'section' => $model->section, 'category' => $model->complain_category], ['class' => 'glyphicon glyphicon-star']);
	echo Html::a(Yii::t('button', '3'), ['norm/rate', 'id_argument' => $modelArgument['id'], 'rating' =>3, 'norm' => $model['id'], 'section' => $model->section, 'category' => $model->complain_category], ['class' => 'glyphicon glyphicon-star']);
	echo Html::a(Yii::t('button', '4'), ['norm/rate', 'id_argument' => $modelArgument['id'], 'rating' =>4, 'norm' => $model['id'], 'section' => $model->section, 'category' => $model->complain_category], ['class' => 'glyphicon glyphicon-star']);
	echo Html::a(Yii::t('button', '5'), ['norm/rate', 'id_argument' => $modelArgument['id'], 'rating' =>5, 'norm' => $model['id'], 'section' => $model->section, 'category' => $model->complain_category], ['class' => 'glyphicon glyphicon-star']);
}
?>