<?php

use yii\helpers\Html;
use yii\grid\GridView;
use common\modules\nam\models\norm\Argument;
use common\modules\nam\models\content\Content;
use yii\data\ActiveDataProvider;
use yii\widgets\ActiveForm;
use kartik\popover\PopoverX;
use common\modules\nam\models\norm\ArgumentRate;
use kartik\rating\StarRating;
use yii\helpers\Url;

/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */
?>

<link href="css/form-control.css" media="all" type="text/css" rel="stylesheet"  />
<?php $categoria2 = htmlspecialchars($model['complain_category']); ?>
<?php $section2 = htmlspecialchars($model['section']); ?>

<?= Html::beginForm(
        Url::toRoute(['norm/detail','category' => $categoria2, 'section' => $section2]),//action
        "get",//method
        ['class' => 'form-inline']//options
    );
?>

<div class="form-group">
    <input type="radio" name="order" value="relevant"> Most relevant
    <input type="radio" name="order" value="newest"> Newest
    <input type="radio" name="order" value="oldest"> Oldest 
</div>

<?= Html::submitInput("Sort Arguments", ["class" => "btn btn-primary btn-xs"]) ?>

<?= Html::endForm() ?>
</br>

<h4><?php /*
if($model->active==0){?>
	<span class="label label-default"><?= "Under discussion" ?></span>
<?php
		echo '<small>Time Remaining: '.gmdate('H:i',$model->closing-time()).' </small>';
}else if($model->active==2){?>
	<span class="label label-danger"><?= "Closed" ?></span>
	<?php
}else{?>
	<span class="label label-success"><?= "Active" ?></span>
<?php
} */ echo "Norm:     ";
?>



<span>
	<?=Yii::t('norm',$model['name']);?>
	<b><span title="Category"><?= Html::encode($model->complainCategory['description']);?></span></b>
	<?=Yii::t('norm','at');?>
	<b><span title="Section"><?= Html::encode($model->section0['description']);?></span></b>
	<?=Yii::t('norm','section');?>
	</span>
	<?php generateStarIcons($model['rating']);?>
</h4>
<?php if($model->active==0){
	echo '<small>Time Remaining: '.gmdate('H:i',$model->closing-time()).' </small>'; } ?>
<div class="tree">
    <ul>
		
		<li>
			<!--<ul>-->
			<ul>
				<span id="arguments">
				<?php 
					$argCount = Argument::find()->select(['COUNT(*)'])->where('type = 1 && norm = '.$model['id'])->count();	
				?>
                <!--<li>-->
                	<span class="label label-success"><i class="icon-minus-sign"></i><?=Yii::t('norm','Arguments in favour')?> <?php echo "(".$argCount.")" ?></span> <?php generateStarIcons($model['ratingpos']);?>  
                    <ul>
                    	<?php
                    	showArguments(1, $model);
                  		?>
                    </ul>
					 <?php //if(!$model->active) echo Html::a(Yii::t('button', 'Add Argument'), ['norm/addargument', 'norm' => $model['id'], 'positive' => 1, 'category' => $model->complain_category, 'section' => $model->section], ['class' => 'label label-primary']);?>
					<?php if (!$model->active) { //echo "Model id: ".$model['id']." Model seccio: ".$model['section']." Model categoria: ".$model['complain_category']."";

					?>  
					</br>
						<div class="argument-form">
							
							<form id="w0" action="/socialNorms/frontend/web/index.php?r=nam%2Fnorm%2Faddargument&amp;norm= <?php echo htmlspecialchars($model['id']); ?> &amp;positive=1&amp;category= <?php echo htmlspecialchars($model['complain_category']); ?> &amp;section= <?php echo htmlspecialchars($model['section']); ?> " method="post">
								<input type="hidden" name="_csrf" value="ckdkcHoxNlNGDhczSUB7ARwuVzgcYVUmARE0OAlDXDonNC4SD25ePA==">
								<div class="form-group field-argument-description required">
								<textarea id="argument-description" class="form-control" name="Argument[description]" maxlength="140" placeholder="I'm in favour of this norm because..."></textarea>

								<div class="help-block"></div>
								</div>
								<div class="form-group">
								<button type="submit" class="label label-primary" id="addArgument">Add argument</button>    </div>

							</form>
						</div>
					<?php } ?>
				<!--</li>-->
				</span>
				<span id="arguments">
				<?php $argCount = Argument::find()->select(['COUNT(*)'])->where('type = 2 && norm = '.$model['id'])->count(); ?>
                <!--<li>-->
                	<span class="label label-danger"><i class="icon-minus-sign"></i><?=Yii::t('norm','Arguments against')?> <?php echo "(".$argCount.")" ?></span> <?php generateStarIcons($model['ratingneg']);?>  
                    <ul>
						<?php
                    	showArguments(2, $model);
                  		?>
                    </ul>
					<?php //if(!$model->active) echo Html::a(Yii::t('button', 'Add Argument'), ['norm/addargument', 'norm' => $model['id'], 'positive' => 2, 'category' => $model->complain_category, 'section' => $model->section], ['class' => 'label label-primary']);?>
                <?php if (!$model->active) { //echo "Model id: ".$model['id']." Model seccio: ".$model['section']." Model categoria: ".$model['complain_category']."";

					?>  
					</br>
						<div class="argument-form">
							
							<form id="w0" action="/socialNorms/frontend/web/index.php?r=nam%2Fnorm%2Faddargument&amp;norm= <?php echo htmlspecialchars($model['id']); ?> &amp;positive=2&amp;category= <?php echo htmlspecialchars($model['complain_category']); ?> &amp;section= <?php echo htmlspecialchars($model['section']); ?> " method="post">
								<input type="hidden" name="_csrf" value="ckdkcHoxNlNGDhczSUB7ARwuVzgcYVUmARE0OAlDXDonNC4SD25ePA==">
								<div class="form-group field-argument-description required">
								<textarea id="argument-description" class="form-control" name="Argument[description]" maxlength="140" placeholder="I'm against this norm because..."></textarea>

								<div class="help-block"></div>
								</div>
								<div class="form-group">
								<button type="submit" class="label label-primary" id="addArgument">Add argument</button>    </div>

							</form>
						</div>
					<?php } ?>
				<!--</li>-->
				</span>
			</ul>
            <!--</ul>-->
		</li>
	</ul>
</div>

<?php
/**
 * Function to show the arguments of the norm
 * @param unknown $type Type of the argument
 * @param unknown $model Norm model
 */
function showArguments($type, $model){
	$sql = 'select * from argument where type = '.$type.' && norm = '.$model['id'];
	$query = Argument::findBySql($sql);
	$dataProvider = new ActiveDataProvider(['query' => $query]);
	$models = $dataProvider->models;
	$rate = 0;
	$normalizedRate = 0.0;
	$normalizedNumRate = 0;
	$relevance=0.0;
	$i=0;
	foreach($models as $modelArgument){		
			$conn = new mysqli('localhost', 'root', '', 'yii2advanced');
			$sql = 'select * from argument where type = '.$type.' && norm = '.$model['id'];
			$result = $conn->query($sql);
			while($row = $result->fetch_assoc()) {
				$i=$i+$row['numrate'];
			
			}
			$normalizedRate=$modelArgument['rate']/5.0;
				
			
			if ($i>0) { $normalizedNumRate = $modelArgument['numrate']/$i;}
			$i=0;
			
			$relevance= 0.6*$normalizedRate+0.4*$normalizedNumRate;
			
			$normalizedNumRate=0.0;

			$sql = 'update argument set relevance='.$relevance.' where type = '.$type.' && id =' .$modelArgument['id'];
			$result = $conn->query($sql);
			
		?>
	       
<?php }
	if ((isset($_REQUEST['order'])) && ($_REQUEST['order']=='newest') ){
		$sql = 'select * from argument where type = '.$type.' && norm = '.$model['id'].' ORDER BY id DESC';
	} else if ((isset($_REQUEST['order'])) && ($_REQUEST['order']=='oldest') ){
		$sql = 'select * from argument where type = '.$type.' && norm = '.$model['id'].' ORDER BY id ASC';
	} else {
		$sql = 'select * from argument where type = '.$type.' && norm = '.$model['id'].' ORDER BY relevance DESC';
	}
	$query = Argument::findBySql($sql);
	$dataProvider = new ActiveDataProvider(['query' => $query]);
	$models = $dataProvider->models;

	foreach($models as $modelArgument){
		?><li>
			<?php
			$description = $modelArgument['description'];
			if(is_numeric($description)){
				$content = Content::findOne($description);
				echo 'Content such as '.Html::a(Html::encode($content['title']), ['/nam/content/view', 'id' => $modelArgument['description']], ['class' => '']) .' should not be published to upload this content ';
				echo generateStarIcons($modelArgument['rate']).'  ('.$modelArgument['numrate']?><i class="fa fa-user"></i><?php echo ')' ?>
			<?php }else{
				echo Html::encode($description)." ";
				echo generateStarIcons($modelArgument['rate']).'  ('.$modelArgument['numrate']?><i class="fa fa-user"></i><?php echo ')';?>
			<?php }
				$content = '<form name="form" action="" method="get"> <input class="rating" data-max="5" data-min="1" id="input" type="number"/> </form>' ;?>
			<?php
	           if(ArgumentRate::isRated($modelArgument['id']) && (!$model->active)){
	           ?>	<span>Rate argument:<?php
	           	echo Html::a(Yii::t('button', '1'), ['norm/rate', 'id_argument' => $modelArgument['id'], 'rating' =>1, 'norm' => $model['id'], 'section' => $model->section, 'category' => $model->complain_category], ['class' => 'glyphicon glyphicon-star']);
	           	echo Html::a(Yii::t('button', '2'), ['norm/rate', 'id_argument' => $modelArgument['id'], 'rating' =>2, 'norm' => $model['id'], 'section' => $model->section, 'category' => $model->complain_category], ['class' => 'glyphicon glyphicon-star']);
	           	echo Html::a(Yii::t('button', '3'), ['norm/rate', 'id_argument' => $modelArgument['id'], 'rating' =>3, 'norm' => $model['id'], 'section' => $model->section, 'category' => $model->complain_category], ['class' => 'glyphicon glyphicon-star']);
	           	echo Html::a(Yii::t('button', '4'), ['norm/rate', 'id_argument' => $modelArgument['id'], 'rating' =>4, 'norm' => $model['id'], 'section' => $model->section, 'category' => $model->complain_category], ['class' => 'glyphicon glyphicon-star']);
	           	echo Html::a(Yii::t('button', '5'), ['norm/rate', 'id_argument' => $modelArgument['id'], 'rating' =>5, 'norm' => $model['id'], 'section' => $model->section, 'category' => $model->complain_category], ['class' => 'glyphicon glyphicon-star']);
	           	?></span>
	           	<?php
	           }
	           ?>
	   	</li><?php
	}
}?>
<?php
/**
 * Function to show the arguments of the norm
 * @param unknown $type Type of the argument
 * @param unknown $model Norm model
 
function showNumArguments($type, $model, $num){
	$sql = 'select * from argument where type = '.$type.' && norm = '.$model['id'].' LIMIT' .$num;
	$query = Argument::findBySql($sql);
	$dataProvider = new ActiveDataProvider(['query' => $query]);
	$models = $dataProvider->models;
	$rate = 0;
	foreach($models as $modelArgument){
		$conn = new mysqli('localhost', 'root', '', 'yii2advanced');
			$sql = 'select * from argument where type = '.$type.' && norm = '.$model['id'];
			$result = $conn->query($sql);
			while($row = $result->fetch_assoc()) {
				$i=$i+$row['numrate'];
			
			}
			$normalizedRate=$modelArgument['rate']/5.0;
				
			
			if ($i>0) { $normalizedNumRate = $modelArgument['numrate']/$i;}
			$i=0;
			$relevance= 0.6*$normalizedRate+0.4*$normalizedNumRate;
            $normalizedNumRate=0.0;

			$sql = 'update argument set relevance='.$relevance.' where type = '.$type.' && id =' .$modelArgument['id'];
			$result = $conn->query($sql);
			
		?>
	       
<?php }
	$sql = 'select * from argument where type = '.$type.' && norm = '.$model['id'].' ORDER BY relevance DESC LIMIT' .$num;
	$query = Argument::findBySql($sql);
	$dataProvider = new ActiveDataProvider(['query' => $query]);
	$models = $dataProvider->models;

	foreach($models as $modelArgument){
		?><li>
			<?php
			$description = $modelArgument['description'];
			if(is_numeric($description)){
				$content = Content::findOne($description);
				echo 'Content such as '.Html::a(Html::encode($content['title']), ['/nam/content/view', 'id' => $modelArgument['description']], ['class' => '']) .' should not be published to upload this content ';
				echo generateStarIcons($modelArgument['rate']).'  ('.$modelArgument['numrate']?><i class="fa fa-user"></i><?php echo ')' ?>
			<?php }else{
				echo Html::encode($description)." ";
				echo generateStarIcons($modelArgument['rate']).'  ('.$modelArgument['numrate']?><i class="fa fa-user"></i><?php echo ')';?>
			<?php }
				$content = '<form name="form" action="" method="get"> <input class="rating" data-max="5" data-min="1" id="input" type="number"/> </form>' ;?>
			<?php
	           if(ArgumentRate::isRated($modelArgument['id']) && (!$model->active)){
	           ?>	<span>Rate argument:<?php
	           	echo Html::a(Yii::t('button', '1'), ['norm/rate', 'id_argument' => $modelArgument['id'], 'rating' =>1, 'norm' => $model['id'], 'section' => $model->section, 'category' => $model->complain_category], ['class' => 'glyphicon glyphicon-star']);
	           	echo Html::a(Yii::t('button', '2'), ['norm/rate', 'id_argument' => $modelArgument['id'], 'rating' =>2, 'norm' => $model['id'], 'section' => $model->section, 'category' => $model->complain_category], ['class' => 'glyphicon glyphicon-star']);
	           	echo Html::a(Yii::t('button', '3'), ['norm/rate', 'id_argument' => $modelArgument['id'], 'rating' =>3, 'norm' => $model['id'], 'section' => $model->section, 'category' => $model->complain_category], ['class' => 'glyphicon glyphicon-star']);
	           	echo Html::a(Yii::t('button', '4'), ['norm/rate', 'id_argument' => $modelArgument['id'], 'rating' =>4, 'norm' => $model['id'], 'section' => $model->section, 'category' => $model->complain_category], ['class' => 'glyphicon glyphicon-star']);
	           	echo Html::a(Yii::t('button', '5'), ['norm/rate', 'id_argument' => $modelArgument['id'], 'rating' =>5, 'norm' => $model['id'], 'section' => $model->section, 'category' => $model->complain_category], ['class' => 'glyphicon glyphicon-star']);
	           	?></span>
	           	<?php
	           }
	           ?>
	   	</li><?php
	} 
} */ ?>

<?php

function generateStarIcons($number){
	//Full star
	$num = floor($number);
	$rest = $number-$num;
	echo '<i title="'.round($number,2).'">';
	for($i=0; $i<$num; $i++){
		echo '<i class="fa fa-star yellow"></i>';
	}

	//Half star
	if($rest >= 0.5){
		echo '<i class="fa fa-star-half-empty yellow"></i>';
		$i++;
	}

	//Empty star
	for($j=$i; $j<5; $j++){
		echo '<i class="fa fa-star-o yellow"></i>';
	}
	echo '</i>';
	
	echo Html::a('<i class="icon-info-sign"></i>', null, [
    'rel' => 'popover',
    'data-trigger' => 'hover',
    'data-title' => 'Your title',
    'data-content' => 'Your content',
	]);
}
?>

<link href="http://maxcdn.bootstrapcdn.com/font-awesome/4.1.0/css/font-awesome.min.css" rel="stylesheet">
