/*!
 * @package   yii2-grid
 * @author    Kartik Visweswaran <kartikv2@gmail.com>
 * @copyright Copyright &copy; Kartik Visweswaran, Krajee.com, 2015
 * @version   3.0.0
 *
 * Grid Export Validation Module for Yii's Gridview. Supports export of
 * grid data as CSV, HTML, or Excel.
 *
 * Author: Kartik Visweswaran
 * Copyright: 2015, Kartik Visweswaran, Krajee.com
 * For more JQuery plugins visit http://plugins.krajee.com
 * For more Yii related demos visit http://demos.krajee.com
 */!function(e){"use strict";var t=function(e,t,o){return e.split(t).join(o)},o=function(t,o){return null===t||void 0===t||0===t.length||o&&""===e.trim(t)},n=function(e,t,o,n){var i=screen.width/2-o/2,r=60,s=window.open("",t,"",!0);return s.close(),window.open(e,t,"toolbar=no, location=no, directories=no, status=yes, menubar=no, scrollbars=no, resizable=no, copyhistory=no, width="+o+", height="+n+", top="+r+", left="+i)},i=function(e){return e.toLowerCase().replace(/[^\w ]+/g,"").replace(/ +/g,"-")},r={html:'<!DOCTYPE html><meta http-equiv="Content-Type" content="text/html;charset={encoding}"/><meta http-equiv="X-UA-Compatible" content="IE=edge;chrome=1"/>{css}<style>.kv-wrap{padding:20px;}.kv-align-center{text-align:center;}.kv-align-left{text-align:left;}.kv-align-right{text-align:right;}.kv-align-top{vertical-align:top!important;}.kv-align-bottom{vertical-align:bottom!important;}.kv-align-middle{vertical-align:middle!important;}.kv-page-summary{border-top:4px double #ddd;font-weight: bold;}.kv-table-footer{border-top:4px double #ddd;font-weight: bold;}.kv-table-caption{font-size:1.5em;padding:8px;border:1px solid #ddd;border-bottom:none;}</style><body class="kv-wrap">{data}</body>',pdf:"{before}\n{data}\n{after}",excel:'<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel"xmlns="http://www.w3.org/TR/REC-html40"><head><meta http-equiv="Content-Type" content="text/html;charset={encoding}"/>{css}<!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{worksheet}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--></head><body>{data}</body></html>',popup:'<html style="display:table;width:100%;height:100%;"><title>Grid Export - &copy; Krajee</title><body style="display:table-cell;font-family:Helvetica,Arial,sans-serif;color:#888;font-weight:bold;line-height:1.4em;text-align:center;vertical-align:middle;width:100%;height:100%;padding:0 10px;">{msg}</body></html>'},s=function(t,o){this.$element=e(t);var n=o.gridOpts,i=o.genOpts;this.$grid=e("#"+n.gridId),this.messages=n.messages,this.target=n.target,this.exportConversions=n.exportConversions,this.showConfirmAlert=n.showConfirmAlert,this.filename=i.filename,this.showHeader=i.showHeader,this.showFooter=i.showFooter,this.showPageSummary=i.showPageSummary,this.$table=this.$grid.find(".kv-grid-table:first"),this.$form=this.$grid.find("form.kv-export-form"),this.encoding=this.$form.find('[name="export_encoding"]').val(),this.columns=this.showHeader?"td,th":"td",this.alertMsg=o.alertMsg,this.config=o.config,this.popup="",this.listen()};s.prototype={constructor:s,getArray:function(t){var n=this,r=n.clean(t),s=[],l={};return void 0!==n.config.colHeads&&n.config.colHeads.length>0?s=n.config.colHeads:r.find("thead tr th").each(function(t){var r=e(this).text(),l=i(r);s[t]=!n.config.slugColHeads||o(l)?"col_"+t:l}),r.find('tbody tr:has("td")').each(function(t){l[t]={},e(this).children("td").each(function(o){var n=s[o];l[t][n]=e(this).text()})}),l},notify:function(e){var t=this;if(!t.showConfirmAlert)return e.preventDefault(),!0;var n=t.messages,i=o(t.alertMsg)?"":t.alertMsg,r=o(n.allowPopups)?"":n.allowPopups,s=o(n.confirmDownload)?"":n.confirmDownload,l="";return l=i.length&&r.length?i+"\n\n"+r:!i.length&&r.length?r:i.length&&!r.length?i:"",s.length&&(l=l+"\n\n"+s),e.preventDefault(),o(l)?!0:t.kvConfirm(l)},kvConfirm:function(e){try{return window.confirm(e)}catch(t){return!0}},setPopupAlert:function(e){var t=this;if(void 0!==t.popup.document)if(arguments.length&&arguments[1]){var o=t.popup.document.getElementsByTagName("body");setTimeout(function(){o[0].innerHTML=e},4e3)}else{var n=r.popup.replace("{msg}",e);t.popup.document.write(n)}},listenClick:function(e){var t=this,n=arguments.length>1?arguments[1]:"";t.$element.on("click",function(i){t.notify(i)&&(o(n)?t[e]():t[e](n),i.preventDefault())})},listen:function(){var e=this;"_popup"===e.target&&e.$form.on("submit",function(){setTimeout(function(){e.setPopupAlert(e.messages.downloadComplete,!0)},1e3)}),e.$element.hasClass("export-csv")&&e.listenClick("exportTEXT","csv"),e.$element.hasClass("export-txt")&&e.listenClick("exportTEXT","txt"),e.$element.hasClass("export-html")&&e.listenClick("exportHTML"),e.$element.hasClass("export-xls")&&e.listenClick("exportEXCEL"),e.$element.hasClass("export-json")&&e.listenClick("exportJSON"),e.$element.hasClass("export-pdf")&&e.listenClick("exportPDF")},clean:function(e){var t=this,o=t.$table.clone();o.find("tr.filters").remove(),o.find("th").removeAttr("rowspan"),o.find("input").remove(),t.showHeader||o.find("thead").remove(),t.showPageSummary||o.find("tfoot.kv-page-summary").remove(),t.showFooter||o.find("tfoot.kv-table-footer").remove(),t.showCaption||o.find("kv-table-caption").remove(),o.find(".skip-export").remove(),o.find(".skip-export-"+e).remove();var n=o.html();return n=t.preProcess(n),o.html(n),o},preProcess:function(e){var o,n=this,i=n.exportConversions,r=i.length,s=e;if(r>0)for(var l=0;r>l;l++)o=i[l],s=t(s,o.from,o.to);return s},download:function(e,t){var i=this,r=i.$element.data("format"),s=o(i.config)?{}:i.config;i.$form.find('[name="export_filetype"]').val(e),i.$form.find('[name="export_filename"]').val(i.filename),i.$form.find('[name="export_content"]').val(t),i.$form.find('[name="export_mime"]').val(r),i.$form.find('[name="export_config"]').val("pdf"===e?JSON.stringify(s):""),"_popup"===i.target&&(i.popup=n("","kvDownloadDialog",350,120),i.popup.focus(),i.setPopupAlert(i.messages.downloadProgress)),i.$form.submit()},exportHTML:function(){var t=this,o=t.clean("html"),n=t.config,i=t.config.cssFile&&n.cssFile.length?'<link href="'+t.config.cssFile+'" rel="stylesheet">':"",s=r.html.replace("{encoding}",t.encoding).replace("{css}",i).replace("{data}",e("<div />").html(o).html());t.download("html",s)},exportPDF:function(){var t=this,n=t.clean("pdf"),i=o(t.config.contentBefore)?"":t.config.contentBefore,s=o(t.config.contentAfter)?"":t.config.contentAfter,l=t.config.css,a=r.pdf.replace("{css}",l).replace("{before}",i).replace("{after}",s).replace("{data}",e("<div />").html(n).html());t.download("pdf",a)},exportTEXT:function(t){var o=this,n=o.clean(t),i=n.find("tr:has("+o.columns+")"),r=String.fromCharCode(11),s=String.fromCharCode(0),l='"'+o.config.colDelimiter+'"',a='"'+o.config.rowDelimiter+'"',c='"'+i.map(function(t,n){var i=e(n),s=i.find(o.columns);return s.map(function(t,o){var n=e(o),i=n.text();return i.replace('"','""')}).get().join(r)}).get().join(s).split(s).join(a).split(r).join(l)+'"';o.download(t,c)},exportJSON:function(){var e=this,t=e.getArray("json");t=JSON.stringify(t,e.config.jsonReplacer,e.config.indentSpace),e.download("json",t)},exportEXCEL:function(){var t=this,o=t.clean("xls"),n=t.config,i=n.cssFile&&t.config.cssFile.length?'<link href="'+t.config.cssFile+'" rel="stylesheet">':"",s=r.excel.replace("{encoding}",t.encoding).replace("{css}",i).replace("{worksheet}",t.config.worksheet).replace("{data}",e("<div />").html(o).html()).replace(/"/g,"'");t.download("xls",s)}},e.fn.gridexport=function(t){var o=Array.apply(null,arguments);return o.shift(),this.each(function(){var n=e(this),i=n.data("gridexport"),r="object"==typeof t&&t;i||n.data("gridexport",i=new s(this,e.extend({},e.fn.gridexport.defaults,r,e(this).data()))),"string"==typeof t&&i[t].apply(i,o)})},e.fn.gridexport.defaults={},e.fn.gridexport.Constructor=s}(window.jQuery);