/* Using jet lib: jet_tree. general lib */
/************************************************************************
 *
 *  A sample taylor.h
 *     Here is a list of macros/functions needed to compile the auto
 *     generated taylor polynomial procedure.  
 *
 */


#ifdef __cplusplus
extern "C"
{
#endif
/***********************************************************************
 *
 * Code generated by the TAYLOR translator.
 */

#ifndef _NUMBER_OF_JET_VARS_
#define _NUMBER_OF_STATE_VARS_         3
#define _NUMBER_OF_JET_VARS_           3
#define _NUMBER_OF_SYMBOLS_            3
#define _DEGREE_OF_JET_VARS_           5
#define _JET_COEFFICIENTS_COUNT_TOTAL_ 56
static int _number_of_jet_vars_ =      3;
static int _number_of_symbols_  =      3;
static int _degree_of_jet_vars_ =      5;
static int _monomial_counts_[]  =      {1,3,6,10,15,21};
static int _monomial_offsets_[] =      {0,1,4,10,20,35,56};
static int _size_of_jet_variable_ =    56;
#define _SIZE_OF_JET_VAR_              56
#endif

#ifndef _TAYLOR_H_
#define _TAYLOR_H_
typedef double MY_FLOAT;

#include<math.h>
#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<ctype.h>
/*
 *  MY_FLOAT is the data type to be used in computing derivatives. 
 *  It may be 'float', 'double' or user defined private data types
 *  like 'long double', 'complex' etc. 
 */

/* for double or long double, don't need to initialize */
#define   InitMyFloat(r)            
#define   ClearMyFloat(r)           
 
/* assign b to a */
#define   AssignMyFloat(a, b)       {(a)=(b);}

/* create a MY_FLOAT from a, assigne to r. a is an integer or a float */
#define   MakeMyFloatA(r,a)         (r=(double)(a))

/* create a MY_FLOAT from string, a is an integer or a float, s is its string representation */
#define   MakeMyFloatC(r,s,a)       (r=(double)(a))

/* create a MY_FLOAT from a, assign to r and return r */
#define   MakeMyFloatB(r,a)         (r=(double)(a),r)

/* addition r=a+b   */
#define   AddMyFloatA(r,a,b)        (r=(a)+(b))
#define   AddMyFloatD               AddMyFloatA
#define   AddMyFloatSI              AddMyFloatA

/* substraction r=a-b */
#define   SubtractMyFloatA(r,a,b)   (r=(a)-(b))
#define   SubtractMyFloatD          SubtractMyFloatA
#define   SubtractMyFloatSI         SubtractMyFloatA
#define   SubtractSIMyFloat         SubtractMyFloatA

/* multiplication r=a*b */
#define   MultiplyMyFloatA(r,a,b)   (r=(a)*(b))
#define   MultiplyMyFloatD          MultiplyMyFloatA
#define   MultiplyMyFloatSI         MultiplyMyFloatA

/* division r=a/b */
#define   DivideMyFloatA(r,a,b)     (r=(a)/(b))
#define   DivideMyFloatD(r,a,b)     (r=(a)/(double)(b))
#define   DivideMyFloatSI           DivideMyFloatD

/* division by an integer r=a/i */
#define   DivideMyFloatByInt(r,a,i)    (r=(a)/(double)(i))
/* negation r=-a*/
#define   NegateMyFloatA(r,a)          (r= -(a))

/* square root r=sqrt(a) */
#define   sqrtMyFloatA(r,a)            (r=sqrt(a))
/* exponentiation r=a^b */
#define   ExponentiateMyFloatA(r,a,b)  (r=pow((a),(b)))
/* exponentiation r=a^b, b is an integer */
#define   ExponentiateMyFloatIA(r,a,b) (r=pow((a),(double)(b)))
/* sin(a)  r=sin(a) */
#define   sinMyFloatA(r,a)             (r=sin((a)))
/* cos(a)  r=cos(a) */
#define   cosMyFloatA(r,a)             (r=cos((a)))
/* tan(a)  r=tan(a) */
#define   tanMyFloatA(r,a)             (r=tan((a)))
/* atan(a) r=atan(a) */
#define   atanMyFloatA(r,a)            (r=atan((a)))
/* exp(a)  r=exp(a) */
#define   expMyFloatA(r,a)             (r=exp((a)))
/* log(a)  r=log(a) */
#define   logMyFloatA(r,a)             (r=log((a)))
/* sinh(a) r=sinh(a) */
#define   sinhMyFloatA(r,a)            (r=sinh(a))
/* cosh(a) r=cosh(a) */
#define   coshMyFloatA(r,a)            (r=cosh(a))
/* tanh(a) r=tanh(a) */
#define   tanhMyFloatA(r,a)            (r=tanh(a))


/* log10(a)  r=log10(a) */
#define   log10MyFloatA(r,a)           (r=log10((a)))
/* fabs(a) r=fabs(a) */
#define   fabsMyFloatA(r,a)            (r=fabs(a))

/* convert to int */
#define   MyFloatToInt(ir,fa)          (ir=(int)(fa))
/* convert to double */
#define   MyFloatToDouble(ir,fa)       (ir=(double)(fa))


/* boolean operation  */
#define   MyFloatA_GE_B(a,b)        ((a)>=(b))
#define   MyFloatA_GT_B(a,b)        ((a)> (b))
#define   MyFloatA_LE_B(a,b)        ((a)<=(b))
#define   MyFloatA_LT_B(a,b)        ((a)< (b))
#define   MyFloatA_EQ_B(a,b)        ((a)==(b))
#define   MyFloatA_NEQ_B(a,b)       ((a)!=(b))


#define   OutputMyFloat(a)          fprintf(stdout,"%g ",(double)a)
#define   OutputMyFloat3(file,format,a)     fprintf(file,format,(double)a)

/************************************************************************/

#endif

/*** MY_JET ***/
#ifndef _MY_JET_H_
#define _MY_JET_H_
static int _tr_idx_map_[] = {
  0,  1,  2,  3,  4,  5,  7,  6,  8,  9, 10, 11, 14, 12, 15, 17, 13, 16, 18, 19,
 20, 21, 25, 22, 26, 29, 23, 27, 30, 32, 24, 28, 31, 33, 34, 35, 36, 41, 37, 42,
 46, 38, 43, 47, 50, 39, 44, 48, 51, 53, 40, 45, 49, 52, 54, 55, -1};
#define MY_JET_DATA(x,i) ((x->coef)[_tr_idx_map_[i]])
/* HEADER jet_tree_t_lorenz4_eq */
 
#include <stdio.h>
typedef struct jet_tree_t_lorenz4_eq_node
{
  int nsymb, deg;
  MY_FLOAT *coef;
  struct jet_tree_t_lorenz4_eq_node *term;
} jet_tree_t_lorenz4_eq_node;
typedef jet_tree_t_lorenz4_eq_node* jet_tree_ptr_lorenz4_eq_node;


typedef jet_tree_t_lorenz4_eq_node* jet_tree_t_lorenz4_eq;
//#define jet_tree_ptr_lorenz4_eq jet_tree_t_lorenz4_eq
typedef jet_tree_t_lorenz4_eq* jet_tree_ptr_lorenz4_eq;

size_t jet_tree_init_lorenz4_eq(jet_tree_ptr_lorenz4_eq);
void jet_tree_initup_lorenz4_eq(int, int);
int jet_tree_set_num_symbs_lorenz4_eq(int);
int jet_tree_set_deg_lorenz4_eq(int);
void jet_tree_cleanup_lorenz4_eq(void);
void jet_tree_clean_lorenz4_eq(jet_tree_ptr_lorenz4_eq);

void jet_tree_set_lorenz4_eq(jet_tree_t_lorenz4_eq, jet_tree_t_lorenz4_eq);
void jet_tree_set_scal_lorenz4_eq(jet_tree_t_lorenz4_eq, MY_FLOAT);

void jet_tree_set_scal_array_lorenz4_eq(jet_tree_t_lorenz4_eq, MY_FLOAT*);
void jet_tree_set_jet_2_scal_array_lorenz4_eq(MY_FLOAT*, jet_tree_t_lorenz4_eq);

void jet_tree_set_d_lorenz4_eq(jet_tree_t_lorenz4_eq, double);
void jet_tree_set_si_lorenz4_eq(jet_tree_t_lorenz4_eq, int);

void jet_tree_to_scal_lorenz4_eq(MY_FLOAT[1], jet_tree_t_lorenz4_eq);
void jet_tree_eval_lorenz4_eq(MY_FLOAT[1], jet_tree_t_lorenz4_eq, MY_FLOAT[]);
void jet_tree_get_coef_lorenz4_eq(MY_FLOAT[1], jet_tree_t_lorenz4_eq, const int[]);
void jet_tree_set_coef_lorenz4_eq(jet_tree_t_lorenz4_eq, const int[], MY_FLOAT);

void jet_tree_nrminf_lorenz4_eq(MY_FLOAT[1], jet_tree_t_lorenz4_eq);
void jet_tree_nrm2_lorenz4_eq(MY_FLOAT[1], jet_tree_t_lorenz4_eq);

void jet_tree_neg_lorenz4_eq(jet_tree_t_lorenz4_eq, jet_tree_t_lorenz4_eq);

void jet_tree_add2_lorenz4_eq(jet_tree_t_lorenz4_eq, jet_tree_t_lorenz4_eq, jet_tree_t_lorenz4_eq);
void jet_tree_sub2_lorenz4_eq(jet_tree_t_lorenz4_eq, jet_tree_t_lorenz4_eq, jet_tree_t_lorenz4_eq);
void jet_tree_mul2_lorenz4_eq(jet_tree_t_lorenz4_eq, jet_tree_t_lorenz4_eq, jet_tree_t_lorenz4_eq);
void jet_tree_div2_lorenz4_eq(jet_tree_t_lorenz4_eq, jet_tree_t_lorenz4_eq, jet_tree_t_lorenz4_eq);

void jet_tree_add2_scal_lorenz4_eq(jet_tree_t_lorenz4_eq, jet_tree_t_lorenz4_eq, MY_FLOAT);
void jet_tree_sub2_scal_lorenz4_eq(jet_tree_t_lorenz4_eq, jet_tree_t_lorenz4_eq, MY_FLOAT);
void jet_tree_scal_sub2_lorenz4_eq(jet_tree_t_lorenz4_eq, MY_FLOAT, jet_tree_t_lorenz4_eq);
void jet_tree_mul2_scal_lorenz4_eq(jet_tree_t_lorenz4_eq, jet_tree_t_lorenz4_eq, MY_FLOAT);
void jet_tree_div2_scal_lorenz4_eq(jet_tree_t_lorenz4_eq, jet_tree_t_lorenz4_eq, MY_FLOAT);
void jet_tree_scal_div2_lorenz4_eq(jet_tree_t_lorenz4_eq, MY_FLOAT, jet_tree_t_lorenz4_eq);

void jet_tree_add2_d_lorenz4_eq(jet_tree_t_lorenz4_eq, jet_tree_t_lorenz4_eq, double);
void jet_tree_sub2_d_lorenz4_eq(jet_tree_t_lorenz4_eq, jet_tree_t_lorenz4_eq, double);
void jet_tree_d_sub2_lorenz4_eq(jet_tree_t_lorenz4_eq, double, jet_tree_t_lorenz4_eq);
void jet_tree_mul2_d_lorenz4_eq(jet_tree_t_lorenz4_eq, jet_tree_t_lorenz4_eq, double);
void jet_tree_div2_d_lorenz4_eq(jet_tree_t_lorenz4_eq, jet_tree_t_lorenz4_eq, double);
void jet_tree_d_div2_lorenz4_eq(jet_tree_t_lorenz4_eq, double, jet_tree_t_lorenz4_eq);

void jet_tree_add2_si_lorenz4_eq(jet_tree_t_lorenz4_eq, jet_tree_t_lorenz4_eq, int);
void jet_tree_sub2_si_lorenz4_eq(jet_tree_t_lorenz4_eq, jet_tree_t_lorenz4_eq, int);
void jet_tree_si_sub2_lorenz4_eq(jet_tree_t_lorenz4_eq, int, jet_tree_t_lorenz4_eq);
void jet_tree_mul2_si_lorenz4_eq(jet_tree_t_lorenz4_eq, jet_tree_t_lorenz4_eq, int);
void jet_tree_div2_si_lorenz4_eq(jet_tree_t_lorenz4_eq, jet_tree_t_lorenz4_eq, int);
void jet_tree_si_div2_lorenz4_eq(jet_tree_t_lorenz4_eq, int, jet_tree_t_lorenz4_eq);

void jet_tree_set_sqrt_lorenz4_eq(jet_tree_t_lorenz4_eq, jet_tree_t_lorenz4_eq);

void jet_tree_set_pow_scal_lorenz4_eq(jet_tree_t_lorenz4_eq, jet_tree_t_lorenz4_eq, MY_FLOAT);

void jet_tree_set_exp_lorenz4_eq(jet_tree_t_lorenz4_eq, jet_tree_t_lorenz4_eq);
void jet_tree_set_log_lorenz4_eq(jet_tree_t_lorenz4_eq, jet_tree_t_lorenz4_eq);

void jet_tree_set_sin_lorenz4_eq(jet_tree_t_lorenz4_eq, jet_tree_t_lorenz4_eq);
void jet_tree_set_cos_lorenz4_eq(jet_tree_t_lorenz4_eq, jet_tree_t_lorenz4_eq);
void jet_tree_set_tan_lorenz4_eq(jet_tree_t_lorenz4_eq, jet_tree_t_lorenz4_eq);
void jet_tree_set_atan_lorenz4_eq(jet_tree_t_lorenz4_eq, jet_tree_t_lorenz4_eq);

void jet_tree_set_sinh_lorenz4_eq(jet_tree_t_lorenz4_eq, jet_tree_t_lorenz4_eq);
void jet_tree_set_cosh_lorenz4_eq(jet_tree_t_lorenz4_eq, jet_tree_t_lorenz4_eq);

void jet_tree_fprintf_lorenz4_eq(FILE *file, const char *, jet_tree_t_lorenz4_eq);
#define jet_tree_printf_lorenz4_eq(fmt,a) jet_tree_fprintf_lorenz4_eq(stdout,fmt,a)


/* Macros used in the integration */
typedef jet_tree_t_lorenz4_eq MY_JET;
#define InitUpJet2(nsymbs,deg)     jet_tree_initup_lorenz4_eq(nsymbs,deg)
#define InitUpJet()                InitUpJet2(_NUMBER_OF_SYMBOLS_,_DEGREE_OF_JET_VARS_)
#define InitJet(a)                 jet_tree_init_lorenz4_eq(&(a))
#define ClearJet(a)                jet_tree_clean_lorenz4_eq(&(a))
#define ClearUpJet()               jet_tree_cleanup_lorenz4_eq()
#define SetJetVarDegree(a)         jet_tree_set_deg_lorenz4_eq(a)
#define SetNumSymbols(a)           jet_tree_set_num_symbs_lorenz4_eq(a)
#define InitJetParameter(a,i)      undefined
	
#define NormJet(a,x)               jet_tree_nrminf_lorenz4_eq(&(a),x)
#define NormJet2(a,x)              jet_tree_nrm2_lorenz4_eq(&(a),x)

#define NegateJetA(t,s)            jet_tree_neg_lorenz4_eq(t,s)
#define AssignJetToFloat(t,s)      jet_tree_to_scal_lorenz4_eq(&(t),s)
#define AssignFloatToJet(t,f)      jet_tree_set_scal_lorenz4_eq(t,f)


#define AssignJetToFloatArray(t,s)  jet_tree_set_jet_2_scal_array_lorenz4_eq(t,s)
#define AssignFloatArrayToJet(t,f)  jet_tree_set_scal_array_lorenz4_eq(t,f)


#define AssignJetToJet(t,s)        jet_tree_set_lorenz4_eq(t,s)
#define AddJetJetA(t,a,b)          jet_tree_add2_lorenz4_eq(t,a,b)
#define AddFloatJetA(t,a,b)        jet_tree_add2_scal_lorenz4_eq(t,b,a)
#define AddJetFloatA(t,a,b)        jet_tree_add2_scal_lorenz4_eq(t,a,b)

#define MultiplyJetFloatA(t,a,b)   jet_tree_mul2_scal_lorenz4_eq(t,a,b)
#define MultiplyJetJetA(t,a,b)     jet_tree_mul2_lorenz4_eq(t,a,b)
#define MultiplyFloatJetA(t,a,b)   jet_tree_mul2_scal_lorenz4_eq(t,b,a)

#define DivideFloatJetA(t,a,b)     jet_tree_scal_div2_lorenz4_eq(t,a,b)
#define DivideJetJetA(t,a,b)       jet_tree_div2_lorenz4_eq(t,a,b)
#define DivideJetFloatA(t,a,b)     jet_tree_div2_scal_lorenz4_eq(t,a,b)

#define SubtractFloatJetA(t,a,b)   jet_tree_scal_sub2_lorenz4_eq(t,a,b)
#define SubtractJetFloatA(t,a,b)   jet_tree_sub2_scal_lorenz4_eq(t,a,b)
#define SubtractJetJetA(t,a,b)     jet_tree_sub2_lorenz4_eq(t,a,b)

#define ExponentiateJetCstA(t,s,e) jet_tree_set_pow_scal_lorenz4_eq(t,s,e)

#define cosJetA(t,a)               jet_tree_set_cos_lorenz4_eq(t,a)
#define sinJetA(t,a)               jet_tree_set_sin_lorenz4_eq(t,a)
#define sqrtJetA(t,a)              jet_tree_set_sqrt_lorenz4_eq(t,a)
#define tanJetA(r,a)               jet_tree_set_tan_lorenz4_eq(r,a)
#define atanJetA(r,a)              jet_tree_set_atan_lorenz4_eq(r,a)
#define expJetA(r,a)               jet_tree_set_exp_lorenz4_eq(r,a)
#define logJetA(r,a)               jet_tree_set_log_lorenz4_eq(r,a)
#define sinhJetA(r,a)              jet_tree_set_sinh_lorenz4_eq(r,a)
#define coshJetA(r,a)              jet_tree_set_cosh_lorenz4_eq(r,a)
#define tanhJetA(r,a)              undefined  
#define log10JetA(r,a)             undefined  

#define InputJetFromString(t,a)    taylor_input_jet_from_string(t,a)
#define InputJet(t,a,b)            taylor_input_jet_from_stdin(t,b)
#define OutputJet2File(file,fmt,t) jet_tree_fprintf_lorenz4_eq(file,fmt,t)
#define OutputJet(fmt,t)           OutputJet2File(stdout,fmt,t)

#define EvalJet(v,x,s)             jet_tree_eval_lorenz4_eq(&(v),x,s)
#define GetJetCoefficient(t,x,idx) jet_tree_get_coef_lorenz4_eq(&(t),x,idx)
#define SetJetCoefficient(x,idx,t) jet_tree_set_coef_lorenz4_eq(x,idx,t)
/* END MACROS MY_JET */

/* END HEADER jet_tree_t_lorenz4_eq */

#endif /*_MY_JET_H_ */ 

MY_FLOAT **taylor_coefficients_lorenz4_eq(MY_FLOAT t, MY_FLOAT *x, int order);

MY_FLOAT **taylor_coefficients_lorenz4_eqA(MY_FLOAT t, MY_FLOAT *x, int order, int reuse_last_computation);

MY_FLOAT **taylor_coefficients_lorenz4_eq_A(MY_FLOAT t, MY_FLOAT *x, int order, int reuse_last_computation, MY_JET *jetIn, MY_JET ***jetOut);
int       taylor_step_lorenz4_eq(MY_FLOAT *ti, MY_FLOAT *x, int dir, int step_ctl,
                          double log10abserr, double log10relerr, 
                          MY_FLOAT *endtime, MY_FLOAT *ht, int *order, MY_JET *jetInOut);

/************************************************************************/


/* JET IO Helpers */


/* Set Jet values  */
int taylor_make_jet(MY_JET a, MY_FLOAT *myfloats, double *values);
int taylor_make_identity_jets(MY_JET *inOut, MY_FLOAT *myfloats, double *values);
int taylor_make_unit_jet(MY_JET a, int idx, MY_FLOAT *myfloat, double *value);
int taylor_set_jet(MY_JET a, MY_FLOAT *myfloats, double *values, int include_state);

/* Convert Jet to array */
MY_FLOAT *taylor_convert_jet_to_array(MY_JET a, int include_state);

/* Input/Output Jet */
int taylor_input_jet_from_stdin(MY_JET a, int idx) ;
int taylor_input_jet_from_string(MY_JET a, const char *str);
int taylor_output_jet(FILE *file, char *fmt, MY_JET a);

/* Init/Cleanup Library/Jet */
void taylor_initialize_jet_library();
void taylor_initialize_jet_library2(int nvars, int degree);
void taylor_initialize_jet_variable(MY_JET *jet);
void taylor_clear_jet_variable(MY_JET *jet);
void taylor_clear_up_jet_library();
int taylor_set_jet_variable_number_of_symbols(int);
int taylor_set_jet_variable_degree(int);

void taylor_jet_reduce(MY_JET, double *);
MY_FLOAT *taylor_get_jet_data_array(MY_JET);
const char **taylor_get_variable_names();
const char **taylor_get_jet_monomials();
#ifdef __cplusplus
}
#endif
