
// double pendulum
// H := -2*cos(a)-cos(a+b) + (la^2 -2*(1+cos(b))*la*lb+ (3+2*cos(b))*lb^2)/(3-cos(2*b));

deri_a = ( (2. * la) - 2. * (1. + cos(b)) * lb) / (3. - cos(2. * b));
deri_b = (-2. * (1. + cos(b)) * la + 2. * (3. + 2. * cos(b)) * lb) / (3. - cos(2. * b));
deri_la = -2. * sin(a) - sin(a + b);
deri_lb =-sin(a+b)-(2*sin(b)*la*lb-2*sin(b)*lb^2)/(3-cos(2*b))+2*(la^2-2*(1+cos(b))*la*lb+(3+2*cos(b))*lb^2)/(3-cos(2*b))^2*sin(2*b);

a' = deri_a;
b' = deri_b;
la'= deri_la;
lb'= deri_lb;

// plane to use for the Poincare section 
expr poincare_section = a;

// given hamiltonian, a=0, b and lb, compute la
// la=lb*cos(b)+lb+sqrt(cos(b)^2*lb^2-2*cos(b)^3-4*cos(b)^2-2*lb^2+4*cos(b)+8)


//jet all symbols 2 degree 1;

initialValues=0.0,0.1,0.2,0.3 ;
absoluteErrorTolerance = 1.0E-16;      /* error tolerance for step control */
relativeErrorTolerance = 1.0E-16;      /* error tolerance for step control */
stopTime = 10000;                      /* stop time */
startTime = 0.0;                       /* start time */
number_of_steps=12345678;
number_of_intersections=2000;
crossing=1;


# poincare_section_initials = 0, b, lb*cos(b)+lb+sqrt(cos(b)**2*lb**2-2*cos(b)**3-2*H*cos(b)**2-4*cos(b)**2-2*lb**2+4*cos(b)+4*H+8), lb;
# poincare_section_xlimit = -3.0,3.0;
# Poincare_section_ylimit = -2.0,2.0;
# Poincare_section_slider1 = "Hamiltonian", -3.0, -1.0, 0.01, -1.6, H;
# poincare_section_mouse = b, lb;


jetInitialValues a = "(0.0   1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)";
jetInitialValues b = "(0.1   0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)";
jetInitialValues la ="(0.2   0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)";
jetInitialValues lb ="(0.3   0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)";


