/*
this file contains the routines used to write a realified (but still
stored in complex variables) change of variables into an ascii or
binary file. the change is handled by mp6s or mp6p.
*/

#include <math.h>
#include <stdio.h>
#include <stdlib.h>

extern "C" {
#include "mp6s.h"
#include "mp6p.h"
#include "msgs.h"
}

#include "arit-c.h"

void wrcva6s(complex **c, integer n, char *n1, char *n2)
/*
this routine writes (in real form in an ascii file) the realified
change of variables stored in c (according to mp6s). it is assumed
that c is the result of inserting the realifying change into the
(complex) change of one of the positions. then, the routine takes real
and imaginary part of c (and scales them by sqrt(2) and -sqrt(2)
resp.) to obtain the real change corresponding to the same position
and the related momentum.

parameters:
c:  change of variables corresponding to one of the positions (not
    the momenta).
n:  degree of c.
n1: name of the file to store the realified change for the position
    (input).
n2: name of the file to store the realified change for the momentum
    (input).  */
{
   renum r2,t;
   integer i,j,k[6],m;
   char *fmt;
   FILE *f1,*f2;
   r2=sqrt(2);
   fmt="%2d %2d %2d %2d %2d %2d %24.16e\n";
   f1=fopen(n1,"w");
   if (f1 == NULL) {printf("wrcva6s: %s can not be opened\n",n1); exit(1);}
   f2=fopen(n2,"w");
   if (f2 == NULL) {printf("wrcva6s: %s can not be opened\n",n2); exit(1);}
   for (i=1; i<=n; i++)
   {
      m=ntph6s(i);
      for (j=0; j<m; j++)
      {
         llex6s(j,k,i);
         t=r2*real(c[i][j]);
         fprintf(f1,fmt,k[0],k[1],k[2],k[3],k[4],k[5],t);
         t=-r2*imag(c[i][j]);
         fprintf(f2,fmt,k[0],k[1],k[2],k[3],k[4],k[5],t);
      }
   }
   fclose(f2);
   fclose(f1);
}
void wrcva6p(complex **c, integer n, char *n1, char *n2)
/*

this routine writes (in real form in an ascii file) the realified
change of variables stored in c (according to mp6p). it is assumed
that c is the result of inserting the realifying change into the
(complex) change of one of the positions. then, the routine takes real
and imaginary part of c (and scales them by sqrt(2) and -sqrt(2)
resp.) to obtain the real change corresponding to the same position
and the related momentum.

parameters:
c:  change of variables corresponding to one of the positions (not
    the momenta).
n:  degree of c.
n1: name of the file to store the realified change for the position
    (input).
n2: name of the file to store the realified change for the momentum
    (input).
*/
{
   renum r2,t;
   integer i,j,k[6],m;
   char *fmt;
   FILE *f1,*f2;
   r2=sqrt(2);
   fmt="%2d %2d %2d %2d %2d %2d %24.16e\n";
   f1=fopen(n1,"w");
   if (f1 == NULL) {printf("wrcva6p: %s can not be opened\n",n1); exit(1);}
   f2=fopen(n2,"w");
   if (f2 == NULL) {printf("wrcva6p: %s can not be opened\n",n2); exit(1);}
   for (i=1; i<=n; i++)
   {
      m=ntph6p(i);
      for (j=0; j<m; j++)
      {
         llex6p(j,k,i);
         t=r2*real(c[i][j]);
         fprintf(f1,fmt,k[0],k[1],k[2],k[3],k[4],k[5],t);
         t=-r2*imag(c[i][j]);
         fprintf(f2,fmt,k[0],k[1],k[2],k[3],k[4],k[5],t);
      }
   }
   fclose(f2);
   fclose(f1);
}
void wrcvb6s(complex **c, integer n, char *n1, char *n2)
/*

this routine writes (in real form in a binary file) the realified
change of variables stored in c (according to mp6s). it is assumed
that c is the result of inserting the realifying change into the
(complex) change of one of the positions. then, the routine takes real
and imaginary part of c (and scales them by sqrt(2) and -sqrt(2)
resp.) to obtain the real change corresponding to the same position
and the related momentum.

parameters:
c:  change of variables corresponding to one of the positions (not
    the momenta).
n:  degree of c.
n1: name of the file to store the realified change for the position
    (input).
n2: name of the file to store the realified change for the momentum
    (input).
*/
{
   renum r2,t;
   integer i,j,l,m,inf[4];
   FILE *f1,*f2;
   r2=sqrt(2);
   f1=fopen(n1,"wb");
   if (f1 == NULL) {printf("wrcvb6s: %s can not be opened\n",n1); exit(1);}
   inf[0]=6;  /* number of variables */
   inf[1]=2;  /* kind of symmetry */
   inf[2]=1; /* initial degree */
   inf[3]=n; /* final degree */
   j=fwrite(inf,sizeof(integer),4,f1);
   if (j < 4) iomsg_eb2("wrcvb6s",n1); /* this will stop the program */
   f2=fopen(n2,"wb");
   if (f2 == NULL) {printf("wrcvb6s: %s can not be opened\n",n2); exit(1);}
   j=fwrite(inf,sizeof(integer),4,f2);
   if (j < 4) iomsg_eb2("wrcvb6s",n2); /* this will stop the program */
   for (i=1; i<=n; i++)
   {
      m=ntph6s(i);
      for (j=0; j<m; j++)
      {
         t=r2*real(c[i][j]);
         l=fwrite(&t,sizeof(renum),1,f1);
         t=-r2*imag(c[i][j]);
         l=fwrite(&t,sizeof(renum),1,f2);
      }
   }
   fclose(f2);
   fclose(f1);
}
void wrcvb6p(complex **c, integer n, char *n1, char *n2)
/*

this routine writes (in real form in an ascii file) the realified
change of variables stored in c (according to mp6p). it is assumed
that c is the result of inserting the realifying change into the
(complex) change of one of the positions. then, the routine takes real
and imaginary part of c (and scales them by sqrt(2) and -sqrt(2)
resp.) to obtain the real change corresponding to the same position
and the related momentum.

parameters:
c:  change of variables corresponding to one of the positions (not
    the momenta).
n:  degree of c.
n1: name of the file to store the realified change for the position
    (input).
n2: name of the file to store the realified change for the momentum
    (input).
*/
{
   renum r2,t;
   integer i,j,l,m,inf[4];
   FILE *f1,*f2;
   r2=sqrt(2);
   f1=fopen(n1,"wb");
   if (f1 == NULL) {printf("wrcvb6p: %s can not be opened\n",n1); exit(1);}
   inf[0]=6;  /* number of variables */
   inf[1]=1;  /* kind of symmetry */
   inf[2]=1; /* initial degree */
   inf[3]=n; /* final degree */
   j=fwrite(inf,sizeof(integer),4,f1);
   if (j < 4) iomsg_eb2("wrcvb6p",n1); /* this will stop the program */
   f2=fopen(n2,"wb");
   if (f2 == NULL) {printf("wrcvb6p: %s can not be opened\n",n2); exit(1);}
   j=fwrite(inf,sizeof(integer),4,f2);
   if (j < 4) iomsg_eb2("wrcvb6p",n2); /* this will stop the program */
   for (i=1; i<=n; i++)
   {
      m=ntph6p(i);
      for (j=0; j<m; j++)
      {
         t=r2*real(c[i][j]);
         l=fwrite(&t,sizeof(renum),1,f1);
         t=-r2*imag(c[i][j]);
         l=fwrite(&t,sizeof(renum),1,f2);
      }
   }
   fclose(f2);
   fclose(f1);
}
