/*
this file contains routines to realify a normal form stored in an
expansion handled by mp6s.
*/

#include <stdio.h>
#include <stdlib.h>

#include "arit-c.h"

extern "C" {
#include "mp6s.h"
#include "mp3.h"
}

void rnf6s(complex **h, integer n, complex **hr, integer nr)
/*
this is to realify the hamiltonian (in normal form up to degree n)
contained in h. the result is stored inside hr.

parameters:
h:  complex hamiltonian (of 6 variables with symmetry, see file mp6s.c)
    in complex normal form (input).
n:  degree of h (input).
hr: complex hamiltonian (of three variables, without any symmetry).
    on exit, it will contain the real normal form, depending only on
    the three actions. the imaginary parts should be zero but,
    due to the rounding errors, they aren't. the distance of these
    imaginary parts to zero can give you an idea of the importance
    of the rounding errors (output).
nr: maximum degree that hr can store (input).    
*/
{
   integer check_rlf(integer k[6]);
   complex mui[4],z;
   integer i,j,k[6],k3[3],l,m,r,r2,lloc;
   puts("rnf6s: starting realification...");
/*
   the next array contains the powers of -sqrt(-1)
*/
   mui[0]=complex(1,0);
   mui[1]=complex(0,-1);
   mui[2]=complex(-1,0);
   mui[3]=complex(0,1);
   if (nr < n/2) {puts("rnf6s error: nr too small"); exit(1);}
   for (i=0; i<=nr; i++)
   {
      m=ntph3(i);
      for (j=0; j<m; j++) hr[i][j]=0;
   }
   for (r=2; r<=n; r++)
   {
      r2=r/2;
      m=ntph6s(r);
      for (j=0; j<m; j++)
      {
         z=h[r][j];
         llex6s(j,k,r);
         l=check_rlf(k);
         if (l != 0) continue;
         k3[0]=(k[0]+k[1])/2;
         k3[1]=(k[2]+k[3])/2;
         k3[2]=(k[4]+k[5])/2;
         l=(k[1]+k[3]+k[5])%4;
         lloc=exll3(k3,r2);
         hr[r2][lloc]+=mui[l]*z;
      }
   }
   puts("rnf6s: realification ended.");
   return;
}
integer check_rlf(integer k[6])
/*
this is to check whether k corresponds or not to a monomial that
belongs to the normal form.

parameters:
k: exponent of the monomial (input).

returned value:
0: k belongs to the normal form.
1: otherwise.
*/
{
   integer i,j;
   for (i=0; i<5; i+=2)
   {
      j=(k[i]+k[i+1])%2;
      if (j != 0) return(1);
      j=k[i+1]-k[i];
      if (j != 0) return(1);
   }
   return(0);
}
