/*
this file contais the basic routines to handle polynomials
of 6 variables.
*/

#include <stdio.h>
#include <stdlib.h>

#include "msgs.h"

static integer nor=0;
static natural **clmo;
static integer **psi;
/*
internal variables:
   nor:  maximum degree allowed.
   clmo: clmo[i][j] contains (encoded) the multiindex corresponding
         to the monomial number j inside the monomials of degree i.
   psi: psi[i][j] contains $\psi_{i}(j)$.
*/

integer imp6(integer nr)
/*
this routine initializes the tables used by the manipulator. it has to
be called before using the manipulator.

parameters:
nr: maximum degree we are going to work with.
    it can not be greater than 63.

returned value: number of kbytes allocated by the internal tables.
*/
{
   void prxk6(natural k[]);
   integer i,j,l,nm;
   unsigned long int mem; /* mem: to count the amount of memory used */
   natural k[6];
   if (sizeof(integer) != 4) {puts("imp6: integers need 4 bytes"); exit(1);}
   if (nr > 63) {puts("imp6: maximum degree allowed is 63"); exit(1);}
   if (nor != 0) /* this means that imp6 is already initialized !!! */
      {
         if (nr <= nor)
            {
               mpmsg_i1("imp6",nor);
               return(0);
            }
         mpmsg_i2("imp6",nor,nr,"amp6"); /* this will stop the program */
      }
   nor=nr;
   mem=5*sizeof(integer*); /* this is to count the number of kb. allocated */
   psi=(integer**)malloc(5*sizeof(integer*));
   if (psi == NULL) {puts("imp6 error. no memory (1)."); exit(1);}
   psi -= 2;
   for (i=2; i<=6; i++)
   {
      psi[i]=(integer*)malloc((nr+1)*sizeof(integer));
      if (psi[i] == NULL) {puts("imp6 error. no memory (2)."); exit(1);}
      mem += (nr+1)*sizeof(integer);
   }
   for (j=0; j<=nr; j++) psi[2][j]=j+1;
   for (i=3; i<=6; i++)
   {
      for (j=0; j<=nr; j++)
      {
         psi[i][j]=0;
         for (l=0; l<=j; l++) psi[i][j] += psi[i-1][l];
      }
   }
   mem += (nr+1)*sizeof(natural*);
   clmo=(natural**)malloc((nr+1)*sizeof(natural*));
   if (clmo == NULL) {puts("imp6 error. no memory (3)."); exit(1);}
   for (i=0; i<=nr; i++)
   {
      nm=psi[6][i];
      mem += nm*sizeof(natural);
      clmo[i]=(natural*)malloc(nm*sizeof(natural));
      if (clmo[i] == NULL) {puts("imp6 error. no memory (4)."); exit(1);}
   }
   for (i=0; i<=nr; i++)
   {
      k[0]=i; k[1]=k[2]=k[3]=k[4]=k[5]=0;
      clmo[i][0]=0;
      nm=psi[6][i];
      for (j=1; j<nm; j++)
      {
         prxk6(k);
         clmo[i][j]=k[1]+64L*k[2]+4096L*k[3]+262144L*k[4]+16777216L*k[5];
      }
   }
   mem /= 1024;
   return(mem);
}
void amp6(void)
/*
this routine frees the space allocated by imp6. it should be called
after using the manipulator mp6.
*/
{
   integer i;
   if (nor == 0)
      {
         mpmsg_a1("amp6");
         return;
      }
   for (i=0; i<=nor; i++) free(clmo[i]);
   free(clmo);
   for (i=2; i<=6; i++) free(psi[i]);
   psi += 2;
   free(psi);
   nor=0;
   return;
}
void llex6(integer lloc, integer k[], integer no)
/*
   this routine computes the exponent of the monomial that is in
   the place number lloc of a given degree.

   parameters:
   lloc: relative place (with respect to degree no) we are interested
         in (input).
   k:    exponent of the relative place lloc (output).
   no:   order we are actually working with (input).
*/
{
   natural n;
   integer m;
   if (lloc >= psi[6][no]) {puts("llex6 error."); exit(1);}
   n=clmo[no][lloc];
   k[1]=n%64;
   m=k[1];
   n/=64;
   k[2]=n%64;
   m+=k[2];
   n/=64;
   k[3]=n%64;
   m+=k[3];
   n/=64;
   k[4]=n%64;
   m+=k[4];
   k[5]=n/64;
   m+=k[5];
   k[0]=no-m;
   return;
}
integer exll6(integer k[],integer no)
/*
   this routine computes the place corresponding to the multiindex k.

   parameters:
   k:    multiindex (input).
   no:   degree we are actually working with (input).

   returned value: place corresponding to k.
*/
{
   integer lloc,n,i,n2,n3,n4,n5;
   n=k[0]+k[1]+k[2]+k[3]+k[4]+k[5];
   if (n != no) {puts("exll6 error 1."); exit(1);}
   lloc=0;
   n5=n-k[5];
   for (i=n5+1; i<=n; i++) lloc += psi[5][i];
   n4=n5-k[4];
   for (i=n4+1; i<=n5; i++) lloc += psi[4][i];
   n3=n4-k[3];
   for (i=n3+1; i<=n4; i++) lloc += psi[3][i];
   n2=n3-k[2];
   for (i=n2+1; i<=n3; i++) lloc += psi[2][i];
   lloc += k[1];
   return(lloc);
}
integer ntph6(integer no)
/*
   this routine returns the number of monomials of degree no.

   parameters:
   no: order we are interested in (input).
   returned value: number of monomials of order no.
*/
{
   if (no > nor) {puts("ntph6: error."); exit(1);}
   return(psi[6][no]);
}
void prxk6(natural k[])
/*
   given a multiindex k, this routine computes the next one
   according to the lexicographic order.

   parameters:
   k: array of 6 components containing the multiindex. it is
       overwritten on exit (input and output).
*/
{
   if (k[0] != 0) {k[0]--; k[1]++; return;}
   if (k[1] != 0) {k[0]=k[1]-1; k[1]=0; k[2]++; return;}
   if (k[2] != 0) {k[0]=k[2]-1; k[2]=0; k[3]++; return;}
   if (k[3] != 0) {k[0]=k[3]-1; k[3]=0; k[4]++; return;}
   if (k[4] != 0) {k[0]=k[4]-1; k[4]=0; k[5]++; return;}
   puts("prxk6 error 1."); exit(1);
}
