/*
this file contais the basic routines to handle polynomials
of 3 variables.
*/

#include <stdio.h>
#include <stdlib.h>

#include "msgs.h"

static integer nor=0;
static natural **clmo;
static integer **psi;
/*
internal variables:
   nor:  maximum degree allowed.
   clmo: clmo[i][j] contains (encoded) the multiindex corresponding
         to the monomial number j inside the monomials of degree i.
   psi: psi[i][j] contains $\psi_{i}(j)$.
*/

integer imp3(integer nr)
/*
this routine initializes the tables used by the manipulator. it has to
be called before using the manipulator.

parameters:
nr: maximum degree we are going to work with.
    it can not be greater than 1024.

returned value: number of kbytes allocated by the internal tables.
*/
{
   void prxk3(natural k[]);
   integer i,j,l,nm;
   unsigned long int mem; /* mem: to count the amount of memory used */
   natural k[3];
   if (sizeof(integer) != 4) {puts("imp3: integers need 4 bytes"); exit(1);}
   if (nr > 1024) {puts("imp3: the maximum degree allowed is 1024"); exit(1);}
   if (nor != 0) /* this means that imp3 is already initialized !!! */
      {
         if (nr == nor)
            {
               mpmsg_i1("imp3",nor);
               return(0);
            }
         mpmsg_i2("imp3",nor,nr,"amp3"); /* this will stop the program */
      }
   nor=nr;
   mem=2*sizeof(integer*); /* this is to count the bytes allocated */
   psi=(integer**)malloc(2*sizeof(integer*));
   if (psi == NULL) {puts("imp3 error. no memory (1)."); exit(1);}
   psi -= 2;
   for (i=2; i<=3; i++)
   {
      psi[i]=(integer*)malloc((nr+1)*sizeof(integer));
      if (psi[i] == NULL) {puts("imp3 error. no memory (2)."); exit(1);}
      mem += (nr+1)*sizeof(integer);
   }
   for (j=0; j<=nr; j++) psi[2][j]=j+1;
   for (j=0; j<=nr; j++)
   {
      psi[3][j]=0;
      for (l=0; l<=j; l++) psi[3][j] += psi[2][l];
   }
   mem += (nr+1)*sizeof(natural*);
   clmo=(natural**)malloc((nr+1)*sizeof(natural*));
   if (clmo == NULL) {puts("imp3 error. no memory (3)."); exit(1);}
   for (i=0; i<=nr; i++)
   {
      nm=psi[3][i];
      mem += nm*sizeof(natural);
      clmo[i]=(natural*)malloc(nm*sizeof(natural));
      if (clmo[i] == NULL) {puts("imp3 error. no memory (4)."); exit(1);}
   }
   for (i=0; i<=nr; i++)
   {
      k[0]=i; k[1]=k[2]=0;
      clmo[i][0]=i;
      nm=psi[3][i];
      for (j=1; j<nm; j++)
      {
         prxk3(k);
         clmo[i][j]=k[0]+1024L*k[1]+1048576L*k[2];
      }
   }
   mem /= 1024;
   return(mem);
}
void amp3(void)
/*
this routine frees the memory allocated by imp3. it should be called
after using the manipulator mp3.
*/
{
   integer i;
   if (nor == 0)
      {
         mpmsg_a1("amp3");
         return;
      }
   for (i=0; i<nor; i++) free(clmo[i]);
   free(clmo);
   for (i=2; i<=3; i++) free(psi[i]);
   psi += 2;
   free(psi);
   nor=0;
   return;
}
void llex3(integer lloc, integer k[], integer no)
/*
   this routine computes the exponent of the monomial that is in
   the place number lloc of a given degree.

   parameters:
   lloc: relative place (with respect to degree no) we are interested
         in (input).
   k:    exponent of the relative place lloc (output).
   no:   order we are actually working with (input).
*/
{
   natural n;
   if (lloc > psi[3][no]) {puts("llex3 error."); exit(1);}
   n=clmo[no][lloc];
   k[0]=n%1024;
   n/=1024;
   k[1]=n%1024;
   k[2]=n/1024;
   return;
}
integer exll3(integer k[],integer no)
/*
   this routine computes the place corresponding to the multiindex k.

   parameters:
   k:    multiindex (input).
   no:   degree we are actually working with (input).

   returned value: place corresponding to k.
*/
{
   integer lloc,n,i,n2;
   n=k[0]+k[1]+k[2];
   if (n != no) {puts("exll3 error."); exit(1);}
   lloc=k[1];
   n2=n-k[2];
   for (i=n2+1; i<=n; i++) lloc += psi[2][i];
   return(lloc);
}
integer ntph3(integer no)
/*
   this routine returns the number of monomials of degree no.

   parameters:
   no: order we are interested in (input).

   returned value: number of monomials of order no.
*/
{
   if (no > nor) {puts("ntph3: error."); exit(1);}
   return(psi[3][no]);
}
void prxk3(natural k[])
/*
   given a multiindex k, this routine computes the next one
   according the lexicographic order.

   parameters:
   k: array of 3 components containing the multiindex. it is
      overwritten on exit (input and output).
*/
{
   if (k[0] != 0) {k[0]--; k[1]++; return;}
   if (k[1] != 0) {k[0]=k[1]-1; k[1]=0; k[2]++; return;}
   puts("prxk3 error 1."); exit(1);
}
