/*
this is the main program to transform coordinates. it sends points
from the transformed coordinates (in the normal form or central
manifold) to the initial ones and viceversa. it is assumed that the
changes have been obtained (and written into several files after
realification) by the others programs of the package. the files with
the expansions of the changes of variables have to be in the directory
contained in the variable DATA (see makefile). the program needs three
parameters in the command line: the name of the file with the initial
points (input, assumed to be in the directory pointed by DATA), the
file where the transformed coordinates will be written (output, to be
created in the directory pointed by DATA), and an integer value equal
to 1 or -1. this value determines the direction of the transformation
(if 1, the initial points are assumed to be in normal form coordinates
and the final one in initial coordinates; and viceversa for -1). if
the variable DATA is not defined in the compiler command line (see
makefile), all the files are assumed to be in the current directory.
*/

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "arit-r.h"

/*
now we define the complex type. although it is not necessary in this
program, we need the definition of complex to avoid compiler complains
when processing files io6s.h and io6p.h, since the type complex is
used there in the prototypes of some functions.
*/

typedef struct {
renum re;
renum im;
} complex;

#include "mp6s.h"
#include "mp6p.h"
#include "io6s.h"
#include "io6p.h"
#include "iol.h"
#include "uneix.h"
#include "erpe6.h"
#include "repo.h"
#include "litr5.h"

/*
next lines are to ensure that the variable DATA is defined. it
must contain the directories where data files are going to be
stored/found. it is usually defined in the command line (see
makefile).
*/

#if !defined(DATA)
#define DATA ""
#endif

#include "files-nf.h"

int main(int narg, char *arg[])
{
   void explain(char *s);
   renum a[6][6],y[6],**c,**pi,**pf,e,mu;
   integer i,j,n,np,m,ms,mp,dir;
   char *cc[6],*ipo,*fpo,*cvl,*ctl; /* filenames involved */
   FILE *f;
   if (narg != 4) {explain(DATA); exit(1);}
   ipo=uneix(DATA,arg[1]);
   fpo=uneix(DATA,arg[2]);
   dir=atoi(arg[3]);
   if ((dir != 1) && (dir != -1)) {explain(DATA); exit(1);}
/*
   next lines are to join the path where the files have to be found/stored
   (given by DATA) and the name of the files (defined in files-nf.h)
*/
   if (dir == 1)
      {
         cc[0]=uneix(DATA,CD1);
         cc[1]=uneix(DATA,CD2);
         cc[2]=uneix(DATA,CD3);
         cc[3]=uneix(DATA,CD4);
         cc[4]=uneix(DATA,CD5);
         cc[5]=uneix(DATA,CD6);
      }
      else
      {
         cc[0]=uneix(DATA,CI1);
         cc[1]=uneix(DATA,CI2);
         cc[2]=uneix(DATA,CI3);
         cc[3]=uneix(DATA,CI4);
         cc[4]=uneix(DATA,CI5);
         cc[5]=uneix(DATA,CI6);
      }
   cvl=uneix(DATA,CVL);
   ctl=uneix(DATA,CTL);
   rcvl(a,cvl);
   rctl5(ctl,&n,&mu);
   printf("mass parameter: %24.16e\n",mu);
   puts("degree of the change of variables?");
   scanf("%d",&n); /* we overwrite the variable n read by rctl5 */
/*
   next lines are to pass the mass parameter to the program that will
   perform the numerical integration for the rtbp
*/
   if (dir == 1)
      {
         ctl=uneix(DATA,"rtbp.mu");
         f=fopen(ctl,"w");
         if (f == NULL) {printf("main-tcnf: cannot open %s\n",ctl); exit(1);}
         fprintf(f,"%25.16e\n",mu);
         fclose(f);
      }
   imp6s(n);
   imp6p(n);
   c=(renum**)malloc((n+1)*sizeof(renum*));
   if (c == NULL) {puts("main-tcnf: out of memory (1)"); exit(1);}
   for (i=0; i<=n; i++)
   {
      ms=ntph6s(i);
      mp=ntph6p(i);
      m = ((ms > mp) ? ms : mp);
      c[i]=(renum*)malloc(m*sizeof(renum));
      if (c[i] == NULL) {puts("main: out of memory 2"); exit(1);}
   }
   pi=repo(ipo,6,&np); /* to read the initial points */
   printf("number of read points: %d\n",np);
   pf=(renum**)malloc(np*sizeof(renum*));
   if (pf == NULL) {puts("main-tcnf: out of memory (2)"); exit(1);}
   for (j=0; j<np; j++)
   {
      pf[j]=(renum*)malloc(6*sizeof(renum));
      if (pf[j] == NULL) {puts("main-tcnf: out of memory (3)"); exit(1);}
   }
   if (dir == -1)
      {
         for (j=0; j<np; j++)
         {
            litr5(a,mu,pi[j],y,dir);
            for (i=0; i<6; i++) pi[j][i]=y[i];
         }
      }
   for (i=0; i<4; i++)
   {
      rreb6s(c,1,n,cc[i]);
      for (j=0; j<np; j++)
      {
         ini_erpe6(pi[j],n);
         pf[j][i]=erpe6s(c,n,&e);
         end_erpe6();
      }
   }
   for (i=4; i<6; i++)
   {
      rreb6p(c,1,n,cc[i]);
      for (j=0; j<np; j++)
      {
         ini_erpe6(pi[j],n);
         pf[j][i]=erpe6p(c,n,&e);
         end_erpe6();
      }
   }
   if (dir == 1)
      {
         for (j=0; j<np; j++)
         {
            litr5(a,mu,pf[j],y,dir);
            for (i=0; i<6; i++) pf[j][i]=y[i];
         }
      }
   f=fopen(fpo,"w");
   if (f == NULL) {printf("main-tcnf: cannot open %s\n",fpo); exit(1);}
   fprintf(f,"%d %d\n",np,6);
   for (j=0; j<np; j++)
   {
      for (i=0; i<6; i++) fprintf(f," %24.16e",pf[j][i]);
      fprintf(f,"\n");
   }
   fclose(f);
/*
 that's all.
*/
   for (i=0; i<np; i++) free(pf[i]);
   free(pf);
   for (i=0; i<np; i++) free(pi[i]);
   free(pi);
   for (i=0; i<=n; i++) free(c[i]);
   free(c);
   amp6p();
   amp6s();
   for (i=0; i<6; i++) free(cc[i]); /* it was allocated inside uneix */
   return(0);
}
void explain(char *s)
{
   puts("\nyou must provide three values in the command line:");
   puts("the names of two files and and a flag.");
   puts("the first file contains the initial points and the second");
   puts("one is the file where the transformed points are going");
   puts("to be stored");
   puts("the flag must be 1 or -1. 1 means that we go from normal");
   puts("form coordinates to initial ones, and -1 means the opposite");
   puts("transformation.\n");
   if (strlen(s) == 0)
      {
         puts("both files are assumed to be in the actual directory");
      }
      else
      {
         printf("both files are assumed to be in %s\n\n",s);
      }
   return;
}
