/*
this is the main program to transform coordinates. it sends points
from the transformed coordinates (in the central manifold) to the
initial ones. it is assumed that the changes have been obtained (and
written into several files after realification) by the others programs
of the package). the files with the expansions of the changes of
variables have to be in the directory contained in the variable DATA
(see makefile). the program needs two parameters in the command line:
the name of the file with the initial points (input, assumed to be in
the directory pointed by DATA) and the file where the transformed
coordinates will be written (output, to be created in the directory
pointed by DATA). if the variable DATA is not defined in the compiler
command line (see makefile), all the files are assumed to be in the
current directory.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "arit-r.h"

/*
now we define the complex type. although it is not necessary in this
program, we need the definition of complex to avoid compiler complains
when processing files io6s.h and io6p.h, since the type complex is
used there in the prototypes of some functions.
*/

typedef struct {
renum re;
renum im;
} complex;

#include "mp4s.h"
#include "mp4p.h"
#include "io4s.h"
#include "io4p.h"
#include "iol.h"
#include "uneix.h"
#include "erpe4.h"
#include "repo.h"

/*
next lines are to ensure that the variable DATA is defined. it
must contain the directories where data files are going to be
stored/found. it is usually defined in the command line (see
makefile).
*/

#if !defined(DATA)
#define DATA ""
#endif

#include "files-cm.h"

int main(int narg, char *arg[])
{
   void litr123(renum a[6][6], integer l, renum mu, renum gam,
            renum x[6], renum y[6]);
   renum **c,**pi,**pf,y[6],a[6][6],e,mu,gam;
   integer i,j,li,n,np,m,ms,mp;
   char *cc[6],*ipo,*fpo,*ctl,*cvl; /* filenames involved */
   FILE *f;
   if (narg != 3)
      {
         puts("\nyou must give (in the command line) the names of two files:");
         puts("the first one is the file with the initial points and");
         puts("the second one is the file where the transformed points");
         puts("have to be stored\n");
         if (strlen(DATA) == 0)
            {
               puts("both files are assumed to be in the actual directory");
            }
            else
            {
               printf("both files are assumed to be in %s\n\n",DATA);
            }
         exit(1);
      }
   ipo=uneix(DATA,arg[1]);
   fpo=uneix(DATA,arg[2]);
/*
   next lines are to join the path where the files have to be found/stored
   (given by DATA) and the name of the files (defined in files.h)
*/
   cc[0]=uneix(DATA,CD1);
   cc[1]=uneix(DATA,CD2);
   cc[2]=uneix(DATA,CD3);
   cc[3]=uneix(DATA,CD4);
   cc[4]=uneix(DATA,CD5);
   cc[5]=uneix(DATA,CD6);
   cvl=uneix(DATA,CVL);
   ctl=uneix(DATA,CTL);
   rcvl(a,cvl);
   rctl123(ctl,&li,&n,&mu,&gam);
   printf("equilibrium point: %d\n",li);
   printf("mass parameter: %24.16e\n",mu);
   puts("degree of the change of variables?");
   scanf("%d",&n); /* we overwrite the variable n read by rctl5 */
/*
   next lines are to pass the mass parameter to the program that will
   perform the numerical integration for the rtbp
*/
   ctl=uneix(DATA,"rtbp.mu");
   f=fopen(ctl,"w");
   if (f == NULL) {printf("cannot open %s\n",ctl); exit(1);}
   fprintf(f,"%25.16e\n",mu);
   fclose(f);
   imp4s(n);
   imp4p(n);
   c=(renum**)malloc((n+1)*sizeof(renum*));
   if (c == NULL) {puts("main: out of memory (1)"); exit(1);}
   for (i=0; i<=n; i++)
   {
      ms=ntph4s(i);
      mp=ntph4p(i);
      m = ((ms > mp) ? ms : mp);
      c[i]=(renum*)malloc(m*sizeof(renum));
      if (c[i] == NULL) {puts("main: out of memory (2)"); exit(1);}
   }
   pi=repo(ipo,4,&np);
   printf("number of read points: %d\n",np);
   pf=(renum**)malloc(np*sizeof(renum*));
   if (pf == NULL) {puts("main: out of memory (3)"); exit(1);}
   for (j=0; j<np; j++)
   {
      pf[j]=(renum*)malloc(6*sizeof(renum));
      if (pf[j] == NULL) {puts("main: out of memory (4)"); exit(1);}
   }
   for (i=0; i<4; i++)
   {
      rreb4s(c,1,n,cc[i]);
      for (j=0; j<np; j++)
      {
         ini_erpe4(pi[j],n);
         pf[j][i]=erpe4s(c,n,&e);
         end_erpe4();
      }
   }
   for (i=4; i<6; i++)
   {
      rreb4p(c,1,n,cc[i]);
      for (j=0; j<np; j++)
      {
         ini_erpe4(pi[j],n);
         pf[j][i]=erpe4p(c,n,&e);
         end_erpe4();
      }
   }
   f=fopen(fpo,"w");
   if (f == NULL) {printf("main: cannot open %s\n",fpo); exit(1);}
   fprintf(f,"%d %d\n",np,n);
   for (j=0; j<np; j++)
   {
      litr123(a,li,mu,gam,pf[j],y);
      for (i=0; i<6; i++) fprintf(f,"%25.16e",y[i]);
      fprintf(f,"\n");
   }
   for (j=0; j<np; j++) {free(pi[j]); free(pf[j]);}
   free(pi); free(pf);
   for (i=0; i<=n; i++) free(c[i]);
   free(c);
   amp4p();
   amp4s();
   for (i=0; i<6; i++) free(cc[i]); /* it was allocated inside uneix */
   return(0);
}
void litr123(renum a[6][6], integer l, renum mu, renum gam,
             renum x[6], renum y[6])
/*
this is to transform points coming from the nonlinear change
corresponding to the central manifold computation, into synodical
coordinates.

parameters:
a: change used to diagonalize h2 (input).
x: initial point (input).
y: point in synodical coordinates (output).
*/
{
   int i;
   renum c,w[6],z[6];
   for (i=0; i<6; i++)
      w[i]=a[i][0]*x[0]+a[i][1]*x[1]+a[i][2]*x[2]
          +a[i][3]*x[3]+a[i][4]*x[4]+a[i][5]*x[5];

   z[0]=w[0];   z[1]=w[2]+w[1];
   z[2]=w[2];   z[3]=-w[0]+w[3];
   z[4]=w[4];   z[5]=w[5];

   switch (l)
   {
      case 1:
         c=-1+gam;
         w[0]=-gam*z[0]+mu+c;    w[1]=-gam*z[1];
         w[2]=-gam*z[2];         w[3]=-gam*z[3];
         w[4]=gam*z[4];          w[5]=gam*z[5];
         break;
      case 2:
         c=-1-gam;
         w[0]=-gam*z[0]+mu+c;    w[1]=-gam*z[1];
         w[2]=-gam*z[2];         w[3]=-gam*z[3];
         w[4]=gam*z[4];          w[5]=gam*z[5];
         break;
      case 3:
         c=gam;
         w[0]=gam*z[0]+mu+c;     w[1]=gam*z[1];
         w[2]=gam*z[2];          w[3]=gam*z[3];
         w[4]=gam*z[4];          w[5]=gam*z[5];
         break;
      default:
         printf("tic error: li=%d\n",l);
         exit(1);
   }

   y[0]=w[0];
   y[1]=w[1]-w[2];
   y[2]=w[2];
   y[3]=w[3]+w[0];
   y[4]=w[4];
   y[5]=w[5];

   return;
}
