/*
this is to produce a numerical integration of the normal form. it is
assumed that the normal form is integrable (i.e., it depends only on
actions). this routine is very similar to the one contained in the
file main-nicm.c. the main difference is that here we do not need a
numerical integration to compute the orbit. as the hamiltonian is
integrable (and we have it integrated!), we can simply tabulate the
solution. for more details, look at the paper in doc/mac.ps.
*/

#include <math.h>
#include <stdio.h>
#include <stdlib.h>

#include "uneix.h"

struct {
   double *c;    /* coef. of the hamiltonian */
   double *p[3]; /* working space */
   int **e;      /* exponents corresponding to the coef. of the ham. */
   int nc;       /* actual number of coefficients */
   int mc;       /* maxium number of coefficients */
   int g;        /* degree of the expansion */
} h;

/*
next lines are to ensure that the variable DATA is defined. it
must contain the directories where data files are going to be
stored/found. it is usually defined in the command line (see
makefile).
*/

#if !defined(DATA)
#define DATA ""
#endif

/* HANF contains the name of the file (in directory DATA) with the
hamiltonian in normal form.
*/

#define HANF "nf.res"

int main(void)
{
   void freq(double x[3], double w[3]);
   void memo(int g);
   void llegeix(char *nom);
   double t,p[3],w[3],h,a,r[3],x,y;
   int i,j,g,np;
   char *hanf,*ifi,*ofi;
   FILE *f;
   puts("degree to be used?");
   scanf("%d",&g);
   memo(g);
   hanf=uneix(DATA,HANF);
   ifi=uneix(DATA,"ninf.dad");
   ofi=uneix(DATA,"ninf.res");
   llegeix(hanf);
   f=fopen(ifi,"r");
   if (f == NULL) {printf("main-ninf: cannot open %s\n",ifi); exit(1);}
   fscanf(f,"%d",&np);
   fscanf(f,"%le %le %le",p,p+1,p+2);
   fclose(f);
   f=fopen(ofi,"w");
   if (f == NULL) {printf("main-ninf: cannot open %s\n",ofi); exit(1);}
   freq(p,w);
   t=0.e0;
   h=0.1e0;
   puts("frequencies:");
   printf("%25.16e %25.16e %25.16e\n",w[0],w[1],w[2]);
   fprintf(f,"%d %d\n",np,6);
   for (i=0; i<3; i++) r[i]=sqrt(2*p[i]);
   for (i=0; i<3; i++)
   {
      x=r[i];
      y=0.e0;
      fprintf(f,"%25.16e %25.16e",x,y);
      if (i < 2) {fprintf(f," ");} else {fprintf(f,"\n");}
   }
   for (j=1; j<np; j++)
   {
      for (i=0; i<3; i++)
      {
         a=h*j*w[i];
         x=r[i]*cos(a);
         y=-r[i]*sin(a);
         fprintf(f,"%25.16e %25.16e",x,y);
         if (i < 2) {fprintf(f," ");} else {fprintf(f,"\n");}
      }
   }
   fclose(f);
   return 0;
}
void freq(double x[3], double w[3])
/*
this is to compute the gradient of the normal form at the point x.

parameters:
x: value of the action variables (input).
w: gradient of the hamiltonian (output).
*/
{
   int i,j0,j1,j2;
   h.p[0][0]=1; h.p[1][0]=1; h.p[2][0]=1;
   for (i=1; i<=h.g; i++)
   {
      h.p[0][i]=x[0]*h.p[0][i-1];
      h.p[1][i]=x[1]*h.p[1][i-1];
      h.p[2][i]=x[2]*h.p[2][i-1];
   }
   w[0]=0; w[1]=0; w[2]=0;
   for (i=0; i<h.nc; i++)
   {
      j0=h.e[i][0];
      j1=h.e[i][1];
      j2=h.e[i][2];
      if (j0 != 0)
         w[0]+=j0*h.c[i]*h.p[0][j0-1]*h.p[1][j1]*h.p[2][j2];
      if (j1 != 0)
         w[1]+=j1*h.c[i]*h.p[0][j0]*h.p[1][j1-1]*h.p[2][j2];
      if (j2 != 0)
         w[2]+=j2*h.c[i]*h.p[0][j0]*h.p[1][j1]*h.p[2][j2-1];
   }
   return;
}
void memo(int g)
/*
this routine creates space to store the hamiltonian and related things
*/
{
   int i,m;
   h.g=g;
/*
   m is the number of 3-d monomials of degree between 1 and n
*/
   m=((g*g+11)*g)/6+g*g;
   h.mc=m;
   h.c=(double*)malloc(m*sizeof(double));
   if (h.c == NULL) {printf("memo: out of memory (1). %d\n",m); exit(1);}
   h.e=(int**)malloc(m*sizeof(int*));
   if (h.e == NULL) {printf("memo: out of memory (2). %d\n",m); exit(1);}
   for (i=0; i<m; i++)
   {
      h.e[i]=(int*)malloc(3*sizeof(int));
      if (h.e[i] == NULL) {printf("memo: out of memory (3). %d\n",i); exit(1);}
   }
   for (i=0; i<3; i++)
   {
      h.p[i]=(double*)malloc((g+1)*sizeof(double));
      if (h.p[i] == NULL) {printf("memo: out of memory (4).\n"); exit(1);}
   }
   h.nc=0;
}
void llegeix(char *nom)
/*
this routine reads the reduced hamiltonian.
*/
{
   double x,y;
   int k,i0,i1,i2,g;
   FILE *f;
   f=fopen(nom,"r");
   if (f == NULL) {printf("cannot open the file %s.\n",nom); exit(1);}
   k=0;
   while (fscanf(f,"%d %d %d %le %le",&i0,&i1,&i2,&x,&y) != EOF)
   {
      if (fabs(x) < 1.e-12) continue;
      g=i0+i1+i2;
      if (g > h.g) break;
      if (k == h.mc) {printf("llegeix error: %d\n",k); exit(1);}
      h.c[k]=x;
      h.e[k][0]=i0;
      h.e[k][1]=i1;
      h.e[k][2]=i2;
      ++k;
   }
   printf("total read monomials: %d\n",k);
   h.nc=k;
   fclose(f);
}
