/*
this is the main program to compute the normal form around L5 in the
restricted three body problem.
*/

#include <stdio.h>
#include <stdlib.h>

#include "arit-c.h"

extern "C" {
#include "kill-nf.h"
#include "mp3.h"
#include "mp6s.h"
#include "mp6p.h"
#include "io3.h"
#include "iol.h"
#include "uneix.h"
}

#include "exp-l5.h"
#include "nf6s.h"
#include "rnf6s.h"

/*
next lines are to ensure that the variables DATA and TEMP are
defined. they must contain the directories where data files and
working files are going to be stored/found. they are usually
defined when the compiler is called (see makefile).
*/

#if !defined(DATA)
#define DATA ""
#endif

#if !defined(TEMP)
#define TEMP ""
#endif

/*
next we include the names of the files
*/

#include "files-nf.h"

int main(void)
{
   complex **h,**hr,c[6][6];
   renum mu,cr[6][6];
   integer n,m,i,nr;
   char *ctl,*cvl,*gen,*cmp,*res; /* names of the files */
   ctl=uneix(DATA,CTL);
   cvl=uneix(DATA,CVL);
   gen=uneix(DATA,GEN);
   cmp=uneix(DATA,CMP);
   res=uneix(DATA,RES);
/*   mu=0.95387536e-3;   sun-jupiter */
   mu=1.e0/82.300587e0; /* earth-moon */
   puts("degree?");
   scanf("%d",&n);
   wctl5(ctl,n,mu);
/*
   initializing the manipulator for 6 variables up to degree n
*/
   i=imp6s(n);
/*
   in the next lines we allocate room to store the hamiltonian.
   the hamiltonian is an array of homogeneous polynomials (h[i]
   will contain an homogeneous polynomial of degree i). each homogeneous
   polynomial is stored as an array of complex variables
*/
   h=(complex**)malloc((n+1)*sizeof(complex*));
   if (h == NULL) {puts("main-nf: out of memory (1)"); exit(1);}
   for (i=0; i<=n; i++)
   {
      m=ntph6s(i);
      h[i]=(complex*)malloc(m*sizeof(complex));
      if (h[i] == NULL) {puts("main-nf: out of memory 2"); exit(1);}
   }
/*
   we compute the linear changes of variables that put h2 in
   normal form
*/
   ccvl5(mu,c,cr);
   wcvl(cr,cvl);
/*
   the expansion of the hamiltonian is computed
*/
   exp_l5(mu,c,n,h);
/*
   the normal form is computed
*/
   nf6s(h,n,n,gen,kill_nf);
/*
   the normal form (still in complex form with 6 variables) is written
   to an ascii file. The line is commented out because this is not
   necessary. If you want to see this, uncomment it (but be careful
   with the amount of output produced!).

   wea6s(h,2,n,cmp);
*/
   nr=n/2;
/*
   now let us realify the hamiltonian. note that the degree will be
   halved (due to the kind of change of variables we are using).
*/
   i=imp3(nr);
/*
   as before, we allocate room for the realified hamiltonian
*/
   hr=(complex**)malloc((nr+1)*sizeof(complex*));
   if (hr == NULL) {puts("main-nf: out of memory (3)"); exit(1);}
   for (i=0; i<=nr; i++)
   {
      m=ntph3(i);
      hr[i]=(complex*)malloc(m*sizeof(complex));
      if (hr[i] == NULL) {puts("main-nf: out of memory (4)"); exit(1);}
   }
/*
   the hamiltonian is realified and written to an ascii file
*/
   rnf6s(h,n,hr,nr);
   wea3(hr,1,nr,res);
/*
   let's free the memory used by the normal form
*/
   for (i=0; i<=nr; i++) free(hr[i]);
   free(hr);
   amp3();
   for (i=0; i<=n; i++) free(h[i]);
   free(h);
   amp6s();
   free(res);
   free(cmp);
   free(gen);
   free(cvl);
}
