/*
this is the main program to compute first integrals near L5 in the
restricted three body problem.
*/

#include <stdio.h>
#include <stdlib.h>

#include "arit-c.h"

extern "C" {
#include "mp3.h"
#include "mp6s.h"
#include "io6s.h"
#include "iol.h"
#include "uneix.h"
}

#include "exp-l5.h"
#include "fi.h"
#include "irex.h"
#include "re6s.h"

/*
next lines are to ensure that the variables DATA and TEMP are
defined. they must contain the directories where data files and
temporal/working files are going to be stored/found. they are usually
defined when the compiler is called (see makefile).
*/

#if !defined(DATA)
#define DATA ""
#endif

#if !defined(TEMP)
#define TEMP ""
#endif

/*
next we include the names of the files
*/

#include "files-fi.h"

int main(void)
{
   void real_fi(complex **fi, integer n, complex **w);
   complex c[6][6],**h,**fi,**tr;
   renum mu,cr[6][6];
   integer n,m,i,rf[3];
   char *ctl,*cvl,*res,*tmp;
   ctl=uneix(DATA,CTL);
   cvl=uneix(DATA,CVL);
   res=uneix(DATA,RES);
   tmp=uneix(DATA,TMP);
/*   mu=0.95387536e-3;   sun-jupiter */
   mu=1.e0/82.300587e0; /* earth-moon */
   puts("degree?");
   scanf("%d",&n);
   wctl5(ctl,n,mu);
/*
   initializing the manipulator for 6 variables up to degree n
*/     
   i=imp6s(n);
/*
   in the next lines we allocate room to store the hamiltonian.
   the hamiltonian is an array of homogeneous polynomials (h[i]
   will contain an homogeneous polynomial of degree i). Each homogeneous
   polynomial is stored as an array of complex variables.
*/
   h=(complex**)malloc((n+1)*sizeof(complex*));
   if (h == NULL) {puts("main-fi error: out of memory (1)"); exit(1);}
   for (i=0; i<=n; i++)
   {
      m=ntph6s(i);
      h[i]=(complex*)malloc(m*sizeof(complex));
      if (h[i] == NULL) {puts("main-fi error: out of memory (2)"); exit(1);}
   }
/*
   we compute the linear change of variables to put h2 in complex
   normal form
*/
   ccvl5(mu,c,cr);
   wcvl(cr,cvl);
/*
   the expansion of the hamiltonian is computed
*/
   exp_l5(mu,c,n,h);
/*
   we allocate space to store the first integral
*/
   fi=(complex**)malloc((n+1)*sizeof(complex*));
   if (fi == NULL) {puts("main-fi error: out of memory (3)"); exit(1);}
   for (i=0; i<=n; i++)
   {
      m=ntph6s(i);
      fi[i]=(complex*)malloc(m*sizeof(complex));
      if (fi[i] == NULL) {puts("main-fi error: out of memory (4)"); exit(1);}
   }
/*
   now we compute the (approximate) first integral, in complex
   coordinates
*/
   calc_fi(h,fi,n);
/*
   we free the memory used by the hamiltonian
*/
   for (i=0; i<=n; i++) free(h[i]);
   free(h);
/*
   the first integral is realified
*/
   tr=ini_real(n);
   rf[0]=1;
   rf[1]=1;
   rf[2]=1;
   re6s(rf,fi,n,tr,tmp);
   end_real(tr,n);
/*
   the first integral is written to an ascii file
*/
   wea6s(fi,2,n,res);
/*
   finally, we free the memory used
*/
   for (i=0; i<=n; i++) free(fi[i]);
   free(fi);
   amp6s();
}
