/*
this is the main program to evaluate the first integral.
*/

#include <math.h>
#include <stdio.h>
#include <stdlib.h>

#include "arit-r.h"

/*
now we define the complex type. although it is not necessary in this
program, we need the definition of complex to avoid compiler complains
when processing files io6s.h and io6p.h, since the type complex is
used there in the prototypes of some functions.
*/

typedef struct {
renum re;
renum im;
} complex;

#include "mp6s.h"
#include "io6s.h"
#include "iol.h"
#include "uneix.h"
#include "erpe6.h"
#include "litr5.h"
#include "rk78.h"

/*
next lines are to ensure that the variable DATA is defined. it
must contain the directories where data files are going to be
stored/found. it is usually defined in the command line (see
makefile).
*/

#if !defined(DATA)
#define DATA ""
#endif

#include "files-fi.h"

#define INI "efi.dad"

static double mu; /* routine rtbp below must "see" this value */

int main(void)
{
   void rtbp(double t, double *x, int n, double *y);
   renum a[6][6],x[6],y[6],**fi,e,ei,u,v,t,h,hmi,hma,eai,eri,r,c;
   integer i,n,m,k[6];
   char *ipo,*cvl,*ctl,*res; /* filenames involved */
   char *fmt1,*fmt2;
   FILE *f1;
   fmt1="%d %d %d %d %d %d %le %le";
   fmt2="%le %le %le %le %le %le";
   ipo=uneix(DATA,INI);
   cvl=uneix(DATA,CVL);
   ctl=uneix(DATA,CTL);
   res=uneix(DATA,RES);
/*
   reading data (parameters, first integral (from now on, f.i.), etc.)
*/
   rcvl(a,cvl);
   rctl5(ctl,&n,&mu);
   printf("mass parameter: %24.16e\n",mu);
   r=sqrt(3.e0)/2.e0;
   c=mu-0.5;
   puts("degree of the first integral?");
   scanf("%d",&n); /* we overwrite the variable n read by rctl5 */
   imp6s(n);
   fi=(renum**)malloc((n+1)*sizeof(renum*));
   if (fi == NULL) {puts("main: out of memory 1"); exit(1);}
   for (i=0; i<=n; i++)
   {
      m=ntph6s(i);
      fi[i]=(renum*)calloc(m,sizeof(renum));
      if (fi[i] == NULL) {puts("main: out of memory 2"); exit(1);}
   }
   f1=fopen(res,"r");
   if (f1 == NULL) {printf("cannot open %s\n",res); exit(1);}
   while (fscanf(f1,fmt1,k,k+1,k+2,k+3,k+4,k+5,&u,&v) != EOF)
   {
      m=k[0]+k[1]+k[2]+k[3]+k[4]+k[5];
      if (m > n) continue;
      i=exll6s(k,m);
      fi[m][i]=u;
   }
   fclose(f1);
   f1=fopen(ipo,"r");
   if (f1 == NULL) {printf("cannot open %s\n",ipo); exit(1);}
   fscanf(f1,"%d",&m);
   fscanf(f1,fmt2,x,x+1,x+2,x+3,x+4,x+5);
   fclose(f1);
   t=0;
   x[0] += c;
   x[1] -= r;
   x[2] += r;
   x[3] += c;
/*
   x contains now the initial condition in synodical coordinates
*/
   litr5(a,mu,x,y,-1); /* transforms x to the coord. of the f.i. */
   ini_erpe6(y,n);
   ei=erpe6s(fi,n,&u); /* evaluation of the f.i. */
   end_erpe6();
   printf("%14.7f %24.16e\n",t,ei);
   ini_rk78(6);
   h=0.1e0;
   hmi=1.e-3;
   hma=1.e0;
   for (i=1; i<m; i++)
   {
      rk78(&t,x,&h,1.e-14,hmi,hma,6,rtbp);
      litr5(a,mu,x,y,-1);
      ini_erpe6(y,n);
      e=erpe6s(fi,n,&u);
      end_erpe6();
      eai=fabs(ei-e);
      eri=eai/ei;
      printf("%14.7f %24.16e %14.7e %14.7e\n",t,e,eai,eri);
   }
/*
 that's all.
*/
   end_rk78(6);
   for (i=0; i<=n; i++) free(fi[i]);
   free(fi);
   amp6s();
   return 0;
}
void rtbp(double t, double *x, int n, double *y)
{
   double r1,r13,r2,r23,aux3;
   r1=sqrt((x[0]-mu)*(x[0]-mu)+x[2]*x[2]+x[4]*x[4]);
   r13=r1*r1*r1;
   r2=sqrt((x[0]-mu+1)*(x[0]-mu+1)+x[2]*x[2]+x[4]*x[4]);
   r23=r2*r2*r2;
   aux3=(1-mu)/r13+mu/r23;
   y[0]=x[1]+x[2];
   y[1]=x[3]-(1-mu)*(x[0]-mu)/r13-mu*(x[0]-mu+1)/r23;
   y[2]=-x[0]+x[3];
   y[3]=-x[1]-aux3*x[2];
   y[4]=x[5];
   y[5]=-aux3*x[4];
   return;
}
