/*
this is the main program to produce the expansions for the changes of
variables. it can produce the two changes: the direct one (from final
to initial coordinates) and the inverse one (from initial to final
coordinates). the computed change corresponds to the realification of
the nonlinear change obtained from the generating function. the linear
change that has been used to put h2 in real normal form is not
included here, so one has to take this into account when sending
points from/to initial coordinates (see file main-tcnf.cc). we have
also assumed that the first 4 changes of variables are handled by mp6s
and the two last ones by mp6p.
*/

#include <stdio.h>
#include <stdlib.h>

#include "arit-c.h"

extern "C" {
#include "mp6s.h"
#include "mp6p.h"
#include "uneix.h"
}

#include "cv6sp.h"
#include "irex.h"
#include "re6s.h"
#include "re6p.h"
#include "wrcv6sp.h"

/*
next lines are to ensure that the variables DATA and TEMP are
defined. they must contain the directories where data files and
working files are going to be stored/found. they are usually
defined in the command line (see makefile).
*/

#if !defined(DATA)
#define DATA ""
#endif

#if !defined(TEMP)
#define TEMP ""
#endif

/*
next we include the names of the files
*/

#include "files-nf.h"

int main(void)
{
   complex **cv,**tr;
   integer n,m,i,rf[3];
   char *gen,*tmp,*cd[6],*ci[6]; /* names of the files */
   char flag1,flag2;
   rf[0]=1;
   rf[1]=1;
   rf[2]=1;
   puts("=============================================================");
   puts("main-cvnf: couples of variables to be realified:");
   for (i=0; i<3; i++) {if (rf[i] == 1) printf(" %d ",i+1);}
   puts("\n=============================================================");
   gen=uneix(DATA,GEN);
   tmp=uneix(TEMP,WRK);
   cd[0]=uneix(DATA,CD1);
   cd[1]=uneix(DATA,CD2);
   cd[2]=uneix(DATA,CD3);
   cd[3]=uneix(DATA,CD4);
   cd[4]=uneix(DATA,CD5);
   cd[5]=uneix(DATA,CD6);
   ci[0]=uneix(DATA,CI1);
   ci[1]=uneix(DATA,CI2);
   ci[2]=uneix(DATA,CI3);
   ci[3]=uneix(DATA,CI4);
   ci[4]=uneix(DATA,CI5);
   ci[5]=uneix(DATA,CI6);
   puts("degree?");
   scanf("%d",&n);
   do {
      puts("do you want to compute the (direct) change of variables? (y/n)");
      while ((flag1=getchar()) == '\n');
   } while ((flag1 != 'y') && (flag1 != 'n'));
   do {
      puts("do you want to compute the inverse of the change? (y/n)");
      while ((flag2=getchar()) == '\n');
   } while ((flag2 != 'y') && (flag2 != 'n'));
/*
   initializing the manipulator for 6 variables up to degree n
*/
   i=imp6s(n);
/*
   in the next lines we allocate room to store the changes of variables.
   the change is an array of homogeneous polynomials (cv[j]
   will contain an homogeneous polynomial of degree j). each homogeneous
   polynomial is stored as an array of complex variables
*/
   cv=(complex**)malloc((n+1)*sizeof(complex*));
   if (cv == NULL) {puts("main-cvnf: out of memory (1)"); exit(1);}
   for (i=0; i<=n; i++)
   {
      m=ntph6s(i);
      cv[i]=(complex*)malloc(m*sizeof(complex));
      if (cv[i] == NULL) {puts("main-cvnf: out of memory (2)"); exit(1);}
   }
/*
   next step is to produce the changes of variables. they will be
   written in binary files. if the user wants to store them in ascii
   files, the calls to the routines wrcvb6s and wrcvb6p have to be
   changed to calls to the routines wrcva6s and wrcva6p.
*/
   if ((flag1 == 'y') || (flag2 == 'y'))
      {
         tr=ini_real(n);
         if (flag1 == 'y')
         {
            ccvd6s(1,cv,n,gen);
            re6s(rf,cv,n,tr,tmp);
            wrcvb6s(cv,n,cd[0],cd[1]);

            ccvd6s(3,cv,n,gen);
            re6s(rf,cv,n,tr,tmp);
            wrcvb6s(cv,n,cd[2],cd[3]);
         }
         if (flag2 == 'y')
         {
            ccvi6s(1,cv,n,gen);
            re6s(rf,cv,n,tr,tmp);
            wrcvb6s(cv,n,ci[0],ci[1]);

            ccvi6s(3,cv,n,gen);
            re6s(rf,cv,n,tr,tmp);
            wrcvb6s(cv,n,ci[2],ci[3]);
         }
/*
         for the last two variables the change of variables is of the
         kind mp6p. so we free and re-allocate cv
*/
         for (i=0; i<=n; i++) free(cv[i]);
         free(cv);
         imp6p(n);
         cv=(complex**)malloc((n+1)*sizeof(complex*));
         if (cv == NULL) {puts("main-cvnf: out of memory (5)"); exit(1);}
         for (i=0; i<=n; i++)
         {
            m=ntph6p(i);
            cv[i]=(complex*)malloc(m*sizeof(complex));
            if (cv[i] == NULL) {puts("main-cvnf: out of memory (6)"); exit(1);}
         }
         if (flag1 == 'y')
            {
               ccvd6p(5,cv,n,gen);
               re6p(rf,cv,n,tr,tmp);
               wrcvb6p(cv,n,cd[4],cd[5]);
            }
         if (flag2 == 'y')
            {
               ccvi6p(5,cv,n,gen);
               re6p(rf,cv,n,tr,tmp);
               wrcvb6p(cv,n,ci[4],ci[5]);
            }
         end_real(tr,n);
         amp6p();
      }
   for (i=0; i<=n; i++) free(cv[i]);
   free(cv);
   amp6s();
   for (i=0; i<6; i++) {free(cd[i]); free(ci[i]);}
   free(tmp);
   free(gen);
}
