/*
this is the main program to produce the expansions for the change of
variables for the reduction to the central manifold. we only compute
the direct one (from final to initial coordinates). the computed
change corresponds to the realification of the nonlinear change
obtained from the generating function. the linear change that has been
used to put h2 in real normal form is not included here, so one has to
take this into acount when sending points to initial coordinates (see
file main-tcdcm). We have also assumed that the first 4 changes of
variables are handled by mp6s and the two last ones by mp6p.
*/

#include <stdio.h>
#include <stdlib.h>

#include "arit-c.h"

extern "C" {
#include "mp6s.h"
#include "mp6p.h"
#include "mp4s.h"
#include "mp4p.h"
#include "uneix.h"
}

#include "cv6sp.h"
#include "irex.h"
#include "re6s.h"
#include "re6p.h"
#include "wrcv4sp.h"

/*
next lines are to ensure that the variables DATA and TEMP are
defined. they must contain the directories where data files and
working files are going to be stored/found. they are usually
defined in the command line (see makefile).
*/

#if !defined(DATA)
#define DATA ""
#endif

#if !defined(TEMP)
#define TEMP ""
#endif

/*
next we include the names of the files
*/

#include "files-cm.h"

int main(void)
{
   complex **cv,**tr;
   integer n,m,i,rf[3];
   char *gen,*tmp,*cd[6]; /* names of the files */
   rf[0]=0;
   rf[1]=1;
   rf[2]=1;
   puts("=============================================================");
   puts("main-cvcm: couples of variables to be realified:");
   for (i=0; i<3; i++) {if (rf[i] == 1) printf(" %d ",i+1);}
   puts("\n=============================================================");
   gen=uneix(DATA,GEN);
   tmp=uneix(TEMP,WRK);
   cd[0]=uneix(DATA,CD1);
   cd[1]=uneix(DATA,CD2);
   cd[2]=uneix(DATA,CD3);
   cd[3]=uneix(DATA,CD4);
   cd[4]=uneix(DATA,CD5);
   cd[5]=uneix(DATA,CD6);
   puts("degree?");
   scanf("%d",&n);
/*
   initializing the manipulators up to degree n
*/
   i=imp6s(n);
   i=imp4s(n);
/*
   in the next lines we allocate room to store the changes of
   variables whose expansion is handled by mp6s. the change is an
   array of homogeneous polynomials (cv[i] will contain an homogeneous
   polynomial of degree i). each homogeneous polynomial is stored as
   an array of complex variables
*/
   cv=(complex**)malloc((n+1)*sizeof(complex*));
   if (cv == NULL) {puts("main: out of memory (1)"); exit(1);}
   for (i=0; i<=n; i++)
   {
      m=ntph6s(i);
      cv[i]=(complex*)malloc(m*sizeof(complex));
      if (cv[i] == NULL) {puts("main: out of memory (2)"); exit(1);}
   }
/*
   next step is to produce the changes of variables. they will be
   written in binary files.
*/
   tr=ini_real(n);
   ccvd6s(1,cv,n,gen);
   re6s(rf,cv,n,tr,tmp);
   wrrvb4s(cv,n,cd[0]);

   ccvd6s(2,cv,n,gen);
   re6s(rf,cv,n,tr,tmp);
   wrrvb4s(cv,n,cd[1]);

   ccvd6s(3,cv,n,gen);
   re6s(rf,cv,n,tr,tmp);
   wrcvb4s(cv,n,cd[2],cd[3]);
/*
   for the last two variables the change of variables is of the
   kind mp6p. so we free and re-allocate cv
*/
   for (i=0; i<=n; i++) free(cv[i]);
   imp6p(n);
   imp4p(n);
   for (i=0; i<=n; i++)
   {
      m=ntph6p(i);
      cv[i]=(complex*)malloc(m*sizeof(complex));
      if (cv[i] == NULL) {puts("main: out of memory (3)"); exit(1);}
   }
   ccvd6p(5,cv,n,gen);
   re6p(rf,cv,n,tr,tmp);
   wrcvb4p(cv,n,cd[4],cd[5]);
   end_real(tr,n);
   amp6p();
   amp4p();
   for (i=0; i<=n; i++) free(cv[i]);
   free(cv);
   amp6s();
   amp4s();
   for (i=0; i<6; i++) free(cd[i]);
   free(tmp);
   free(gen);
}
