/*
this is the main program to compute the central manifold around
one of the points L1, L2 or L3 of the spatial restricted three
body problem.
*/

#include <stdio.h>
#include <stdlib.h>

#include "arit-c.h"

extern "C" {
#include "kill-cm.h"
#include "mp3.h"
#include "mp4s.h"
#include "mp6s.h"
#include "io4s.h"
#include "io6s.h"
#include "iol.h"
#include "uneix.h"
}

#include "exp-l123.h"
#include "irex.h"
#include "nf6s.h"
#include "rcm6s.h"


/*
next lines are to ensure that the variables DATA and TEMP are
defined. they must contain the directories where data files and
temporal/working files are going to be stored/found. they are usually
defined when compiling (see makefile).
*/

#if !defined(DATA)
#define DATA ""
#endif

#if !defined(TEMP)
#define TEMP ""
#endif

/*
next we include the names of the files
*/

#include "files-cm.h"

int main(void)
{
   complex **h,c[6][6],**cm2;
   renum mu,gam,cr[6][6];
   integer n,m,i,l,rf[3];
   char *ctl,*cvl,*gen,*cmp,*res,*tmp; /* names of the files */
   ctl=uneix(DATA,CTL);
   cvl=uneix(DATA,CVL);
   gen=uneix(DATA,GEN);
   cmp=uneix(DATA,CMP);
   res=uneix(DATA,RES);
   tmp=uneix(TEMP,WRK);
   mu=3.040423398444176e-06;  /* earth-sun */
/*   mu=1.215058191870689e-02;   earth-moon */
   printf("mu: %25.16e\n",mu);
   puts("libration point (it must be 1, 2, or 3)?");
   scanf("%d",&l);
   if ((l<1) || (l>3)) exit(1);
   puts("degree?");
   scanf("%d",&n);
/*
   initializing the manipulator for 6 variables up to degree n
*/
   i=imp6s(n);
/*
   in the next lines we allocate room to store the hamiltonian.
   the hamiltonian is an array of homogeneous polynomials (h[i]
   will contain an homogeneous polynomial of degree i). each homogeneous
   polynomial is stored as an array of complex variables
*/
   h=(complex**)malloc((n+1)*sizeof(complex*));
   if (h == NULL) {puts("main-cm: out of memory (1)"); exit(1);}
   for (i=0; i<=n; i++)
   {
      m=ntph6s(i);
      h[i]=(complex*)malloc(m*sizeof(complex));
      if (h[i] == NULL) {puts("main-cm: out of memory (2)"); exit(1);}
   }
/*
   we compute the linear changes of variables that put h2 in
   normal form
*/
   gam=ccvl123(mu,c,cr,l);
   wctl123(ctl,l,n,mu,gam);
   wcvl(cr,cvl);
/*
   the expansion of the hamiltonian is computed
*/
   exp_l123(mu,c,n,h,l);
   nf6s(h,n,n,gen,kill_cm); /* reduction to the centre manifold */
/*
   the complex transformed hamiltonian is written to a binary
   file. this is still a 6 variables hamiltonian, but with the
   hyperbolic direction uncoupled from the centre ones.
*/
   web6s(h,2,n,tmp);
/*
   we free and re-allocate space to store a 2dof hamiltonian
*/
   for (i=0; i<=n; i++) free(h[i]);
   i=imp4s(n);
   for (i=0; i<=n; i++)
   {
      m=ntph4s(i);
      h[i]=(complex*)malloc(m*sizeof(complex));
      if (h[i] == NULL) {puts("main-cm: out of memory (3)"); exit(1);}
   }
/*
   now we realify the monomials of the hamiltonian corresponding to
   the centre directions.
*/
   rf[0]=0; rf[1]=1; rf[2]=1;
   cm2=ini_real(n);
   rcm6s(rf,h,n,cm2,tmp);
   end_real(cm2,n);
   i=remove(tmp);
   if (i != 0) printf("main-cm warning: cannot remove %s\n",tmp);
   wcm4s(h,2,n,res,1.e-13); /* this is to write the reduced hamiltonian */
   for (i=0; i<=n; i++) free(h[i]);
   free(h);
   amp4s();
   amp6s();
   free(tmp);
   free(res);
   free(cmp);
   free(gen);
   free(cvl);
}
