/*
this file contains routines that read polynomials handled by mp4p from
a binary or ascii file. note that the definition of 'complex' is done
'by hand', instead of including the file arit-c.h. so, a complex is a
structure containing two doubles.
*/

#include <math.h>
#include <stdio.h>
#include <stdlib.h>

#include "mp4p.h"
#include "msgs.h"

typedef struct {
   double re;
   double im;
} complex;

void rrea4p(double **c, integer ni, integer nf, char *nom)
/*
this is to read a real expansion stored in the ascii file nom.
warning: before reading the file, the routine will fill with zeros
the expansion c, from degree 0 (0, not ni) to nf. if you don't
want this, you should change the marked loop below.

parameters:
c:   read series (output).
ni:  first degree to be read.
nf:  last degree to be read.
nom: name of the ascii file containing the expansion (input).
*/
{
   double a;
   integer i,j,k[4],l,m;
   char *fmt;
   FILE *f;
   fmt="%d %d %d %d %le";
   printf("rrea4p: opening ascii file %s...\n",nom);
   f=fopen(nom,"r");
   if (f == NULL) {printf("rrea4p error: can't open file %s\n",nom); exit(1);}
   for (i=0; i<=nf; i++) /* this is the loop that zeroes c */
   {
      m=ntph4p(i);
      for (j=0; j<m; j++) c[i][j]=0;
   }
   l=0;
   while(fscanf(f,fmt,k,k+1,k+2,k+3,&a) != EOF)
   {
      i=k[0]+k[1]+k[2]+k[3];
      if ((i >= ni) && (i <= nf))
         {
            j=exll4p(k,i);
            c[i][j]=a;
            ++l;
         }
   }
   printf("rrea4p: total number of (read) monomials: %d\n",l);
   printf("rrea4p: closing %s\n",nom);
   fclose(f);
   return;
}
void rreb4p(double **c, integer ni, integer nf, char *nom)
/*
this is to read a real expansion stored in the binary file nom.

parameters:
c:   read series (output).
ni:  first degree to be read.
nf:  last degree to be read.
nom: name of the binary file containing the expansion (input).
*/
{
   integer i,j,k,l,m,inf[4];
   double w;
   FILE *f;
   printf("rreb4p: opening binary file %s...\n",nom);
   f=fopen(nom,"rb");
   if (f == NULL) {printf("rreb4p error: can't open file %s\n",nom); exit(1);}
   j=fread(inf,sizeof(integer),4,f); /* this is the head of the file */
   if (j < 4) {puts("rreb4p error 1."); exit(1);}
   if ((inf[0] != 4) || (inf[1] != 1)) iomsg_eb02("rreb4p",nom,inf[0],inf[1]);
   iomsg_eb01("rreb4p",nom,ni,nf,inf[2],inf[3]);
/*
   the procedure used to read the file is the following: first we set
   the array c (for degrees between ni and nf) to zero and then we read
   the monomials of the file whose degree belong to the interval [ni,nf].
   in this way, all the monomials that are not in the file are considered
   to be zero.
*/
   for (i=ni; i<=nf; i++)
   {
      m=ntph4p(i);
      for (j=0; j<m; j++) c[i][j]=0;
   }
   l=0;
   for (i=inf[2]; i<=inf[3]; i++)
   {
      if (i > nf) break;
      if (i >= ni)
         {
            m=ntph4p(i);
            j=fread(c[i],sizeof(double),m,f);
            if (j < m) {puts("rreb4p: reading error 1"); exit(1);}
            l += j;
         }
         else
         {
            m=ntph4p(i);
            for (j=0; j<m; j++)
            {
               k=fread(&w,sizeof(double),m,f);
               if (k < 1) {puts("rreb4p: reading error 2"); exit(1);}
            }
         }
   }
   printf("rreb4p: total number of (read) monomials: %d\n",l);
   printf("rreb4p: closing %s\n",nom);
   fclose(f);
   return;
}
