/*
this file contains high-level i/o functions (in C) for the polynomials
handled by mp3. the coefficients of the polynomials are assumed to be
complex variables. note that the definition of 'complex' is done 'by
hand', instead of including the file arit-c.h. so, a complex is a
structure containing two doubles.
*/

#include <stdio.h>
#include <stdlib.h>

#include "mp3.h"
#include "msgs.h"

typedef struct {
   double re;
   double im;
} complex;

#define ERR -1 /* value returned by fprintf on failure */

void wea3(complex **h, integer ni, integer nf, char *nom)
/*
this is to write, in ascii format, the expansion h in the file nom.
the file is also created by this routine. if the file already exists,
it is deleted first.

parameters:
h:   expansion to be written (input).
ni:  first degree to be written.
nf:  last degree to be written.
nom: string with the name of the file where h will be written (input).
*/
{
   integer i,j,k[6],l,m,c;
   char *fmt;
   FILE *f;
   fmt="%2d %2d %2d %25.16e %25.16e\n";
   printf("wea3: creating ascii file %s...\n",nom);
   f=fopen(nom,"w");
   if (f == NULL) {printf("wea3 error: can't open file %s\n",nom); exit(1);}
   l=0;
   for (i=ni; i<=nf; i++)
   {
      m=ntph3(i);
      for (j=0; j<m; j++)
      {
         llex3(j,k,i);
         c=fprintf(f,fmt,k[0],k[1],k[2],h[i][j].re,h[i][j].im);
         if (c == ERR)
            {
               fclose(f);
               iomsg_ea2("wea3",l); /* this will stop the program */
            }
         ++l;
      }
   }
   printf("wea3: total number of (written) monomials: %d\n",l);
   printf("wea3: closing %s\n",nom);
   fclose(f);
   return;
}
