/*
this file contains the routines used to compute the first integral
near L5 of the RTBP. the expansions are handled by the routines of
mp6s.c.
*/

#include <stdio.h>
#include <stdlib.h>

#include "arit-c.h"

extern "C" {
#include "mp6s.h"
}

#include "basop6s.h"

void calc_fi(complex **h, complex **fi, integer n)
/*
this routine computes the first integral (up to order n) of the
hamiltonian h, putting the result in fi. it is assumed that h
contains an expansion of order (at least) n, and that fi is
big enough to contain the power expansion of the first integral
up to order n. 

parameters:
h:  complex power expansion of the hamiltonian. it is assumed that
    h2 is diagonalized (input).
fi: first integral (output).
n:  degree of the computed first integral.
*/
{
   void chot(complex **h, complex **fi, integer n, renum w[3]);
   renum w[3],t;
   integer i,j,k[6],m;
/*
   let us initialize fi to 0
*/
   for (i=0; i<=n; i++)
   {
      m=ntph6s(i);
      for (j=0; j<m; j++) fi[i][j]=0;
   }
   puts("Now you should specify the first integral you want to compute.");
   k[0]=1; k[1]=1; k[2]=0; k[3]=0; k[4]=0; k[5]=0;
   i=exll6s(k,2);
   w[0]=imag(h[2][i]);
   puts("coefficient for monomial (1,1,0,0,0,0)?");
   puts("(if you give a negative value, I'll use the corresponding");
   puts("frequency in the hamiltonian)");
   scanf("%le",&t);
   if (t < 0) {fi[2][i]=h[2][i];} else {fi[2][i]=complex(0.e0,t);}
   k[0]=0; k[1]=0; k[2]=1; k[3]=1;
   i=exll6s(k,2);   
   w[1]=imag(h[2][i]);
   puts("coefficient for monomial (0,0,1,1,0,0)?");
   puts("(if you give a negative value, I'll use the corresponding");
   puts("frequency in the hamiltonian, with the opposite sign)");
   scanf("%le",&t);
   if (t < 0) {fi[2][i]=-h[2][i];} else {fi[2][i]=complex(0.e0,t);}
   k[2]=0; k[3]=0; k[4]=1; k[5]=1;
   i=exll6s(k,2);
   w[2]=imag(h[2][i]);
   puts("coefficient for monomial (0,0,0,0,1,1)?");
   puts("(if you give a negative value, I'll use the corresponding");
   puts("frequency in the hamiltonian)");
   scanf("%le",&t);
   if (t < 0) {fi[2][i]=h[2][i];} else {fi[2][i]=complex(0.e0,t);}
   chot(h,fi,n,w);
   return;
}
void chot(complex **h, complex **fi, integer n, renum w[3])
/*
this routine computes the higher order terms of the first integral.

parameters:
h:  complexified hamiltonian, with h[2] in diagonal form, and
    of order at least n (input).
fi: it must contain the monomials of order 2 of the first integral
    you want to compute. when the routine exits, it contains the
    (complexified) first integral up to degree n (input/output).
n:  degree of the expansions (input).
w:  frequencies of h[2] (input).
*/
{
   renum t;
   integer i,j,k[6],nt,r,bn;
   for (r=3; r<=n; r++)
   {
      printf("chot: computing degree %d...\n",r);
      for (i=3; i<=r; i++) papu6s(h[i],i,fi[r-i+2],r-i+2,fi[r],r,1);
      nt=ntph6s(r);
      for (j=0; j<nt; j++)
      {
         llex6s(j,k,r);
         bn=((k[0] == k[1]) && (k[2] == k[3]) && (k[4] == k[5]));
         if (bn)
            {
               fi[r][j]=0;
            }
            else
            {   
               t=1/((k[1]-k[0])*w[0]+(k[3]-k[2])*w[1]+(k[5]-k[4])*w[2]);
               fi[r][j] *= complex(0,t);
            }
      }
   }
   return;
}
