/*
this file contains the basic operations for polynomials of the kind
mp6s and mp6p. this includes poisson brackets and derivatives.
*/

#include <stdio.h>
#include <stdlib.h>

#include "arit-c.h"

extern "C" {
#include "mp6s.h"
#include "mp6p.h"
}

void papu6sp(complex *p1, integer g1, complex *p2, integer g2,
          complex *p3, integer g3, integer flag)
/*
this routine performs the poisson bracket of two homogeneous polynomials
with complex coefficients. it is assumed that the first polynomial is
handled by mp6p and the second one by mp6s. then, the result is also
of the type mp6p.

parameters:
p1:   first homogeneous polynomial (input).
g1:   degree of p1.
p2:   second homogeneous polynomial (input).
g2:   degree of p2.
p3:   {p1,p2} (output).
g3:   degree of p3 (it must be g1+g2-2).
flag: control parameter. if it is equal to 0, the result is stored
      on p3, otherwise it is added to the actual value of p3.
*/
{
   complex w;
   integer k1[6],k2[6],k3[6],i,j,nt1,nt2,nt3,m,l,lloc;
   if (g1+g2-2 != g3)
   {
      printf("papu6sp error. degrees don't match: %d %d %d\n",g1,g2,g3);
      puts("action taken: program aborted");
      exit(1);
   }
   nt1=ntph6p(g1);
   nt2=ntph6s(g2);
   nt3=ntph6p(g3);
   if (flag == 0) {for (i=0; i<nt3; i++) p3[i]=0;}
   for (i=0; i<nt1; i++)
   {
      llex6p(i,k1,g1);
      for (j=0; j<nt2; j++)
      {
         llex6s(j,k2,g2);
         for (l=0; l<6; l++) k3[l]=k1[l]+k2[l];
         w=p1[i]*p2[j];
         m=k1[0]*k2[1]-k2[0]*k1[1];
         if (m != 0)
            {
               k3[0]--;
               k3[1]--;
               lloc=exll6p(k3,g3);
               p3[lloc] += m*w;
               k3[0]++;
               k3[1]++;
            }
         m=k1[2]*k2[3]-k2[2]*k1[3];
         if (m != 0)
            {
               k3[2]--;
               k3[3]--;
               lloc=exll6p(k3,g3);
               p3[lloc] += m*w;
               k3[2]++;
               k3[3]++;
            }
         m=k1[4]*k2[5]-k2[4]*k1[5];
         if (m != 0)
            {
               k3[4]--;
               k3[5]--;
               lloc=exll6p(k3,g3);
               p3[lloc] += m*w;
               k3[4]++;
               k3[5]++;
            }
      }
   }
   return;
}
void dph6s(complex *p, integer np, integer vn, complex *q)
/*
this is to compute the derivative of the homogeneous polynomial p
of degree np with respect to the variable number vn (vn between 1 and 4).
it is assumed that p is a polynomial handled by mp6s and this implies
that the derivative can be handled by mp6s too.

parameters:
p:  homogenous polynomial of degree np (input).
np: degree of p.
vn: variable number with respect to which p is going to be derivated.
    it must be a integer value between 1 and 4.
q:  derivative of p with respect to variable number vn. it is assumed
    that q is big enough to store an homogeneous polynomial of degree
    np-1 (output).
*/
{
   integer j,m,n,k[6],np1,vn1,kv;
   if (np < 2)
      {
         puts("dph6s error. the degree of the polynomial must be at least 2");
         printf("and the actual one is %d\n",np);
         puts("action taken: program aborted");
         exit(1);
      }
   if ((vn < 1) || (vn > 4))
      {
         puts("dph6s error. the variable number is out of range");
         printf("vn: %d\n",vn);
         puts("action taken: program aborted");
         exit(1);
      }
   np1=np-1;
   vn1=vn-1;
   m=ntph6s(np);
   for (j=0; j<m; j++)
   {
      llex6s(j,k,np);
      if (k[vn1] != 0)
         {
            kv=k[vn1]--;
            n=exll6s(k,np1);
            q[n]=kv*p[j];
         }
   }
  return;
}
void dph6p(complex *p, integer np, integer vn, complex *q)
/*
this is to compute the derivative of the homogeneous polynomial p
of degree np with respect to the variable number vn (vn must be 5 or 6).
it is assumed that p is a polynomial handled by mp6s and this implies
that the derivative will be handled by mp6p.

parameters:
p:  homogenous polynomial of degree np (input).
np: degree of p.
vn: variable number with respect to which p is going to be derivated.
    it must be 5 or 6.
q:  derivative of p with respect to variable number vn. it is assumed
    that q is big enough to store an homogeneous polynomial of degree
    np-1 (output).
*/
{
   integer j,m,n,k[6],np1,vn1,kv;
   if (np < 2)
      {
         puts("dph6p error. the degree of the polynomial must be at least 2");
         printf("and the actual one is %d\n",np);
         puts("action taken: program aborted");
         exit(1);
      }
   if ((vn < 5) || (vn > 6))
      {
         puts("dph6p error. the variable number is out of range");
         printf("vn: %d\n",vn);
         puts("action taken: program aborted");
         exit(1);
      }
   np1=np-1;
   vn1=vn-1;
   m=ntph6s(np);
   for (j=0; j<m; j++)
   {
      llex6s(j,k,np);
      if (k[vn1] != 0)
         {
            kv=k[vn1]--;
            n=exll6p(k,np1);
            q[n]=kv*p[j];
         }
   }
  return;
}
