/*
this file contains the basic operations needed in the program, used to
work with polynomials of the kind mp6s. this includes product of
homogeneous polynomials and poisson brackets.
*/

#include <stdio.h>
#include <stdlib.h>

#include "arit-c.h"

extern "C" {
#include "mp6s.h"
}

void pph6s(complex *p1, integer g1, complex *p2, integer g2, complex *p3,
         integer g3, integer flag)
/*
this is to multiply two homogeneous polynomials. both are handled by
mp6s.

parametres:
p1: first homogeneous polynomial (input).
g1: degree of p1.
p2: second homogeneous polynomial (input).
g2: degree of p2.
p3: p1*p2 (output).
g3: degree of p3. the routine checks if g1+g2 == g3.
flag: if it is 0,  the routine performs p3=p1*p2, otherwise
    it does p3=p3+p1*p2.  */
{
   integer nt1,nt2,nt3,i,j,k1[6],k2[6],k3[6],l,lloc;
   if (g1+g2 != g3)
   {
      printf("pph6s error. degrees don't match: %d %d %d\n",g1,g2,g3);
      puts("action taken: program aborted");
      exit(1);
   }
   nt1=ntph6s(g1);
   nt2=ntph6s(g2);
   if (flag == 0)
      {
         nt3=ntph6s(g3);
         for (i=0; i<nt3; i++) p3[i]=0;
      }
   for (i=0; i<nt1; i++)
   {
      llex6s(i,k1,g1);
      for (j=0; j<nt2; j++)
      {
         llex6s(j,k2,g2);
         for (l=0; l<6; l++) k3[l]=k1[l]+k2[l];
         lloc=exll6s(k3,g3);
         p3[lloc] += p1[i]*p2[j];
      }
   }
   return;
}
void papu6s(complex *p1, integer g1, complex *p2, integer g2,
          complex *p3, integer g3, integer flag)
/*
this routine performs the poisson bracket of two homogeneous polynomials
with complex coefficients. both polynomials are assumed to be handled by
mp6s.

parameters:
p1:   first homogeneous polynomial (input).
g1:   degree of p1.
p2:   second homogeneous polynomial (input).
g2:   degree of p2.
p3:   {p1,p2} (output).
g3:   degree of p3 (it must be g1+g2-2).
flag: control parameter. if it is equal to 0, the result is stored
      on p3, otherwise it is added to the actual value of p3.
*/
{
   complex w;
   integer k1[6],k2[6],k3[6],i,j,nt1,nt2,nt3,m,l,lloc;
   if (g1+g2-2 != g3)
   {
      printf("papu6s error. degrees don't match: %d %d %d\n",g1,g2,g3);
      puts("action taken: program aborted");
      exit(1);
   }
   nt1=ntph6s(g1);
   nt2=ntph6s(g2);
   nt3=ntph6s(g3);
   if (flag == 0) {for (i=0; i<nt3; i++) p3[i]=0;}
   for (i=0; i<nt1; i++)
   {
      llex6s(i,k1,g1);
      for (j=0; j<nt2; j++)
      {
         llex6s(j,k2,g2);
         for (l=0; l<6; l++) k3[l]=k1[l]+k2[l];
         w=p1[i]*p2[j];
         m=k1[0]*k2[1]-k2[0]*k1[1];
         if (m != 0)
            {
               k3[0]--;
               k3[1]--;
               lloc=exll6s(k3,g3);
               p3[lloc] += m*w;
               k3[0]++;
               k3[1]++;
            }
         m=k1[2]*k2[3]-k2[2]*k1[3];
         if (m != 0)
            {
               k3[2]--;
               k3[3]--;
               lloc=exll6s(k3,g3);
               p3[lloc] += m*w;
               k3[2]++;
               k3[3]++;
            }
         m=k1[4]*k2[5]-k2[4]*k1[5];
         if (m != 0)
            {
               k3[4]--;
               k3[5]--;
               lloc=exll6s(k3,g3);
               p3[lloc] += m*w;
               k3[4]++;
               k3[5]++;
            }
      }
   }
   return;
}
